package ru.yandex.data.compressor;

public enum LzoConstraint {
    NORMAL(0),
    UNCOMRESSION_SAFE(-1),
    COMPRESSION_LEVEL_1(1),
    COMPRESSION_LEVEL_2(2),
    COMPRESSION_LEVEL_3(3),
    COMPRESSION_LEVEL_4(4),
    COMPRESSION_LEVEL_5(5),
    COMPRESSION_LEVEL_6(6),
    COMPRESSION_LEVEL_7(7),
    COMPRESSION_LEVEL_8(8),
    COMPRESSION_LEVEL_9(9),
    COMPRESSION_MEMORY_8(11),
    COMPRESSION_MEMORY_16(12),
    COMPRESSION_SPEED(15),
    COMPRESSION_BETTER(99),
    COMPRESSION_BEST(999);

    private final int constraintType;

    LzoConstraint(final int constraintType) {
        this.constraintType = constraintType;
    }

    public int type() {
        return constraintType;
    }
}
