package ru.yandex.data.compressor;

public class LzoLibrary {
    static {
        System.loadLibrary("lzo_data_compressor");
    }

    public LzoLibrary() {
    }

    public static byte[] compress(final byte[] inputData, final LzoAlgorithm algorithm, final LzoConstraint constraint)
        throws CompressorException
    {
        try {
            return compress(inputData, (byte) algorithm.ordinal(), constraint.type());
        } catch (RuntimeException e) {
            throw new CompressorException("LzoLibrary.compress failed to process input data", e);
        }
    }

    public static byte[] uncompress(
        final byte[] inputData,
        final LzoAlgorithm algorithm,
        final LzoConstraint constraint)
        throws CompressorException
    {
        try {
            return uncompress(inputData, (byte) algorithm.ordinal(), constraint.type());
        } catch (RuntimeException e) {
            throw new CompressorException("LzoLibrary.compress failed to process input data", e);
        }
    }

    private static native byte[] compress(final byte[] inputData, byte algorithm, int constraint);

    private static native byte[] uncompress(final byte[] inputData, byte algorithm, int constraint);
}
