package ru.yandex.data.compressor;

import javax.annotation.Nonnull;

import ru.yandex.function.StringBuilderable;

public interface LzoTransformer extends StringBuilderable {
    LzoLibrary library();

    LzoActionContext context();

    @Override
    default void toStringBuilder(@Nonnull final StringBuilder sb) {
        sb.append(context().algorithm().name()).append('/').append(context().constraint().name());
    }

    @Override
    default int expectedStringLength() {
        return context().algorithm().name().length() + 1 + context().constraint().name().length();
    }
}
