package ru.yandex.so.dssm.applier;

public class DssmApplier extends DssmApplierBase {
    public DssmApplier(
        final String pathToModel,
        final String layer,
        final boolean preprocessFields,
        final boolean debug)
        throws DssmApplierException
    {
        super(doCreateInstance(pathToModel, layer, preprocessFields, debug));
    }

    private static long doCreateInstance(
        final String pathToModel,
        final String layer,
        final boolean preprocessFields,
        final boolean debug)
        throws DssmApplierException
    {
        try {
            return createInstance(pathToModel, layer, preprocessFields, debug);
        } catch (RuntimeException e) {
            throw new DssmApplierException(
                "Failed to create instance for model <" + pathToModel + '>',
                e);
        }
    }

    private static native long createInstance(
        String pathToModel,
        String layer,
        boolean preprocessFields,
        boolean debug);

    private static native void destroyInstance(final long handle);

    private static native float[] apply(final long handle, final String input);

    @Override
    protected float[] doApply(final long handle, final String input) {
        return apply(handle, input);
    }

    @Override
    public void doDestroy(final long handle) {
        destroyInstance(handle);
    }
}

