#!/bin/bash

set -ex

ulimit -c unlimited

./ya make -rj8 -ttt mail/so/libs/java/dssm_applier/tool
rm -rf dssm_applier_tool
cp -r mail/so/libs/java/dssm_applier/tool/dssm_applier_tool/ .

source mail/so/libs/java/dssm_applier/tool/classpath.sh

GC_ARGS="
-XX:+UnlockExperimentalVMOptions
-XX:+UseG1GC
-Xmx2G
-Xms1G
-Xmn512M
-XX:ParallelGCThreads=8
-XX:ConcGCThreads=1
-XX:G1ConcRefinementThreads=1
-XX:MaxGCPauseMillis=200
-XX:G1MixedGCCountTarget=32
-XX:G1HeapWastePercent=20
-XX:G1AdaptiveIHOPNumInitialSamples=10
"

exec jdk/bin/java $GC_ARGS -Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true -Djavax.xml.accessExternalDTD= -Djavax.xml.accessExternalSchema= -Djava.library.path=dssm_applier_tool -cp $CLASSPATH ru.yandex.so.dssm.applier.DssmApplier $@

