#include <mail/so/libs/jniwrapper_base/jniwrapper_base.h>

#include <contrib/libs/cld2/compact_lang_det.h>

#include <util/generic/string.h>

extern "C" JNIEXPORT jstring JNICALL
Java_ru_yandex_langdetect_LanguageDetector_detectLanguage(
    JNIEnv* env,
    jclass,
    jstring text)
{
    try {
        TString str = NJniWrapper::JStringToUtf(env, text);
        bool is_reliable = false;
        CLD2::Language lang = CLD2::DetectLanguage(str.Data(), str.Size(), true, &is_reliable);
        if (lang != CLD2::TG_UNKNOWN_LANGUAGE &&
            lang != CLD2::UNKNOWN_LANGUAGE)
        {
            const char* langName = CLD2::LanguageCode(lang);
            if (langName) {
                return NJniWrapper::UtfToJString(env, langName);
            }
        }
    } catch (...) {
        NJniWrapper::RethrowAsJavaException(env);
    }
    return nullptr;
}

