#include <mail/so/libs/jniwrapper_base/jniwrapper_base.h>

#include <library/cpp/resource/resource.h>
#include <library/cpp/stopwords/stopwords.h>

#include <util/generic/string.h>
#include <util/stream/str.h>

struct TWrapper {
    TWordFilter WordFilter;

    TWrapper() {
        TString stopWords = NResource::Find("stopword.lst");
        TStringStream stopWordsStream(stopWords);
        WordFilter.InitStopWordsList(stopWordsStream);
    }
};

const TWrapper Wrapper;

extern "C" JNIEXPORT jboolean JNICALL
Java_ru_yandex_stopwords_StopWords_isStopWord(
    JNIEnv* env,
    jclass,
    jstring word)
{
    try {
        TString str = NJniWrapper::JStringToUtf(env, word);
        return Wrapper.WordFilter.IsStopWord(str.Data(), str.Size());
    } catch (...) {
        NJniWrapper::RethrowAsJavaException(env);
        return 0;
    }
}

