package ru.yandex.lua.util;

import core.org.luaj.vm2.LuaError;
import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;

import ru.yandex.function.GenericConsumer;
import ru.yandex.json.parser.JsonException;

class LuaArrayGenericConsumer extends LuaTable implements GenericConsumer<LuaValue, JsonException> {
    @Override
    public void accept(LuaValue v) throws JsonException {
        try {
            set(length() + 1, v);
        } catch (LuaError e) {
            throw new JsonException(e);
        }
    }
}
