package ru.yandex.lua.util;

import core.org.luaj.vm2.LuaValue;

import ru.yandex.function.GenericConsumer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectors;

public class TypesafeLuaArrayContentHandler extends TypesafeLuaValueContentHandler {
    private final LuaArrayGenericConsumer list;
    private final GenericConsumer<LuaValue, ? extends JsonException>
            listConsumer;

    public TypesafeLuaArrayContentHandler(
            final StringCollectors stringCollectors,
            final GenericConsumer<LuaValue, ? extends JsonException>
                    listConsumer) {
        this(new LuaArrayGenericConsumer(),
                stringCollectors,
                listConsumer);
    }

    // CSOFF: ParameterNumber
    private TypesafeLuaArrayContentHandler(
            final LuaArrayGenericConsumer list,
            final StringCollectors stringCollectors,
            final GenericConsumer<LuaValue, ? extends JsonException>
                    listConsumer) {
        super(list, stringCollectors);
        this.list = list;
        this.listConsumer = listConsumer;
    }
    // CSON: ParameterNumber

    @Override
    public void endArray() throws JsonException {
        stackContentHandler.pop();
        // listConsumer.accept(list) must be called only after all elements
        // added to the list, otherwise XPath matching may fail
        listConsumer.accept(list);
    }


}
