package ru.yandex.lua.util;

import core.org.luaj.vm2.LuaTable;
import core.org.luaj.vm2.LuaValue;

import ru.yandex.function.GenericConsumer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StackedContentHandler;
import ru.yandex.json.parser.StringCollectors;

public class TypesafeLuaObjectContentHandler extends StackedContentHandler {
    private final GenericConsumer<LuaValue, ? extends JsonException>
            consumer;
    private final StringCollectors stringCollectors;
    private final LuaTable map;

    public TypesafeLuaObjectContentHandler(
            final GenericConsumer<LuaValue, ? extends JsonException> consumer,
            final StringCollectors stringCollectors) {
        this.consumer = consumer;
        this.stringCollectors = stringCollectors;
        map = new LuaTable();
    }

    // CSOFF: ParameterNumber
    @Override
    public void key(
            final char[] buf,
            final int off,
            final int len,
            final boolean eol) {
        if (eol) {
            stackContentHandler.push(
                    new TypesafeLuaObjectEntryContentHandler(
                            new ValueConsumer(
                                    stringCollectors.keyStringCollector()
                                            .appendLast(buf, off, len),
                                    map),
                            stringCollectors));
        } else {
            stringCollectors.keyStringCollector().append(buf, off, len);
        }
    }
    // CSON: ParameterNumber

    @Override
    public void endObject() throws JsonException {
        stackContentHandler.pop();
        consumer.accept(map);
    }

    private static class ValueConsumer
            implements GenericConsumer<LuaValue, JsonException> {
        private final String key;
        private final LuaTable map;

        ValueConsumer(final String key, final LuaTable map) {
            this.key = key;
            this.map = map;
        }

        @Override
        public void accept(final LuaValue value) {
            map.set(key, value);
        }
    }
}
