package ru.yandex.lua.util;

import java.io.IOException;
import java.io.Reader;

import core.org.luaj.vm2.LuaValue;

import ru.yandex.function.BasicGenericConsumer;
import ru.yandex.function.GenericConsumer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.JsonParser;
import ru.yandex.json.parser.StackContentHandler;
import ru.yandex.json.parser.StackedContentHandler;
import ru.yandex.json.parser.StringCollectors;
import ru.yandex.json.parser.StringCollectorsFactory;

public class TypesafeLuaValueContentHandler extends StackedContentHandler {
    protected final GenericConsumer<LuaValue, ? extends JsonException>
            consumer;
    protected final StringCollectors stringCollectors;

    public TypesafeLuaValueContentHandler(
            final GenericConsumer<LuaValue, ? extends JsonException> consumer) {
        this(consumer, StringCollectorsFactory.INSTANCE.apply(-1L));
    }

    public TypesafeLuaValueContentHandler(
            final GenericConsumer<LuaValue, ? extends JsonException> consumer,
            final StringCollectors stringCollectors) {
        this.consumer = consumer;
        this.stringCollectors = stringCollectors;
    }

    public static JsonParser prepareParser(
            final GenericConsumer<LuaValue, ? extends JsonException> consumer) {
        return new JsonParser(
                new StackContentHandler(
                        new TypesafeLuaValueContentHandler(consumer)));
    }

    public static LuaValue parse(final String str) throws JsonException {
        BasicGenericConsumer<LuaValue, JsonException> consumer =
                new BasicGenericConsumer<>();
        prepareParser(consumer).parse(str);
        return consumer.get();
    }

    public static LuaValue parse(final Reader reader)
            throws IOException, JsonException {
        BasicGenericConsumer<LuaValue, JsonException> consumer =
                new BasicGenericConsumer<>();
        prepareParser(consumer).parse(reader);
        return consumer.get();
    }

    @Override
    public void startObject() {
        stackContentHandler.push(
                new TypesafeLuaObjectContentHandler(
                        consumer,
                        stringCollectors));
    }

    @Override
    public void startArray() {
        stackContentHandler.push(
                new TypesafeLuaArrayContentHandler(
                        stringCollectors,
                        consumer));
    }

    // CSOFF: ParameterNumber
    @Override
    public void value(
            final char[] buf,
            final int off,
            final int len,
            final boolean eol)
            throws JsonException {
        if (eol) {
            consumer.accept(
                    LuaValue.valueOf(
                            stringCollectors.valueStringCollector()
                                    .appendLast(buf, off, len)));
        } else {
            stringCollectors.valueStringCollector().append(buf, off, len);
        }
    }
    // CSON: ParameterNumber

    @Override
    public void value(final long value) throws JsonException {
        consumer.accept(LuaValue.valueOf(value));
    }

    @Override
    public void value(final double value) throws JsonException {
        consumer.accept(LuaValue.valueOf(value));
    }

    @Override
    public void value(final boolean value) throws JsonException {
        consumer.accept(LuaValue.valueOf(value));
    }

    @Override
    public void nullValue() throws JsonException {
        consumer.accept(LuaValue.NIL);
    }
}
