package ru.yandex.parser.mail.received;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.util.ip.CidrListConfig;
import ru.yandex.util.ip.CidrListConfigBuilder;

public abstract class AbstractReceivedChainParserConfigBuilder
    <T extends AbstractReceivedChainParserConfigBuilder<T>>
    implements ConfigBuilder<T>, ReceivedChainParserConfig
{
    private CidrListConfigBuilder yandexNetsConfig;

    protected AbstractReceivedChainParserConfigBuilder(
        final ReceivedChainParserConfig config)
    {
        yandexNetsConfig(config.yandexNetsConfig());
    }

    protected AbstractReceivedChainParserConfigBuilder(
        final IniConfig config,
        final ReceivedChainParserConfig defaults)
        throws ConfigException
    {
        yandexNetsConfig =
            YANDEX_NETS.extract(config, defaults.yandexNetsConfig());
    }

    @Override
    public CidrListConfigBuilder yandexNetsConfig() {
        return yandexNetsConfig;
    }

    public T yandexNetsConfig(final CidrListConfig yandexNetsConfig) {
        this.yandexNetsConfig = new CidrListConfigBuilder(yandexNetsConfig);
        return self();
    }
}

