package ru.yandex.parser.mail.received;

import java.net.InetAddress;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.NoAllocation;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.function.StringBuilderable;

@Immutable
public class ExtendedDomain extends AbstractStringBuilderable {
    private static final String PREFIX = "ExtendedDomain(";
    private static final int PREFIX_LENGTH = PREFIX.length();
    private static final int MAX_INET_ADDRESS_LENGTH = 39;

    @Nullable
    private final String domain;
    @Nullable
    private final InetAddress address;
    @Nullable
    private final TcpInfo tcpInfo;

    public ExtendedDomain(
        @Nullable final String domain,
        @Nullable final InetAddress address,
        @Nullable final TcpInfo tcpInfo)
    {
        this.domain = domain;
        this.address = address;
        this.tcpInfo = tcpInfo;
    }

    @NoAllocation
    @Nullable
    public String domain() {
        String domain = tcpInfoDomain();
        if (domain == null) {
            domain = this.domain;
        }
        return domain;
    }

    @NoAllocation
    @Nullable
    public String heloDomain() {
        String domain = this.domain;
        if (domain == null) {
            domain = tcpInfoDomain();
        }
        return domain;
    }

    @NoAllocation
    @Nullable
    public InetAddress address() {
        InetAddress address = tcpInfoAddress();
        if (address == null) {
            address = this.address;
        }
        return address;
    }

    @NoAllocation
    @Nullable
    public String tcpInfoDomain() {
        if (tcpInfo == null) {
            return null;
        } else {
            return tcpInfo.domain();
        }
    }

    @NoAllocation
    @Nullable
    public InetAddress tcpInfoAddress() {
        if (tcpInfo == null) {
            return null;
        } else {
            return tcpInfo.address();
        }
    }

    @NoAllocation
    @Override
    public int expectedStringLength() {
        int len =
            PREFIX_LENGTH + 3
            + StringBuilderable.calcExpectedStringLength(domain)
            + StringBuilderable.calcExpectedStringLength(tcpInfo);
        if (address == null) {
            len += 4;
        } else{
            len += MAX_INET_ADDRESS_LENGTH;
        }
        return len;
    }

    @Override
    public void toStringBuilder(@Nonnull final StringBuilder sb) {
        sb.append(PREFIX);
        sb.append(domain);
        sb.append(',');
        StringBuilderable.toStringBuilder(sb, tcpInfo);
        sb.append(',');
        if (address == null) {
            sb.append("null");
        } else {
            sb.append(address.getHostAddress());
        }
        sb.append(')');
    }
}

