package ru.yandex.parser.mail.received;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;
import ru.yandex.util.ip.ImmutableCidrListConfig;

public class ImmutableReceivedChainParserConfig
    implements ImmutableConfig, ReceivedChainParserConfig
{
    private final ImmutableCidrListConfig yandexNetsConfig;

    public ImmutableReceivedChainParserConfig(
        final ReceivedChainParserConfig config)
        throws ConfigException
    {
        yandexNetsConfig = YANDEX_NETS.validate(config.yandexNetsConfig());
    }

    @Override
    public ImmutableCidrListConfig yandexNetsConfig() {
        return yandexNetsConfig;
    }
}

