package ru.yandex.parser.mail.received;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ReceivedChainParserConfigBuilder
    extends AbstractReceivedChainParserConfigBuilder
        <ReceivedChainParserConfigBuilder>
{
    public ReceivedChainParserConfigBuilder() {
        super(ReceivedChainParserConfigDefaults.INSTANCE);
    }

    public ReceivedChainParserConfigBuilder(
        final ReceivedChainParserConfig config)
    {
        super(config);
    }

    public ReceivedChainParserConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, ReceivedChainParserConfigDefaults.INSTANCE);
    }

    public ReceivedChainParserConfigBuilder(
        final IniConfig config,
        final ReceivedChainParserConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ReceivedChainParserConfigBuilder self() {
        return this;
    }

    public ImmutableReceivedChainParserConfig build() throws ConfigException {
        return new ImmutableReceivedChainParserConfig(this);
    }
}

