package ru.yandex.parser.mail.received;

import javax.annotation.Nullable;

import com.google.errorprone.annotations.NoAllocation;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.function.StringBuilderable;

public class ReceivedInfo extends AbstractStringBuilderable {
    private static final String PREFIX = "Received(";
    private static final int PREFIX_LENGTH = PREFIX.length();
    private static final int MAX_TIMESTAMP_LENGTH = 10;

    @Nullable
    private final ExtendedDomain from;
    @Nullable
    private final ExtendedDomain by;
    @Nullable
    private final String byComment;
    @Nullable
    private final String protocol;
    @Nullable
    private final String id;
    @Nullable
    private final String recipient;
    private final long timestamp;

    public ReceivedInfo(
        @Nullable final ExtendedDomain from,
        @Nullable final ExtendedDomain by,
        @Nullable final String byComment,
        @Nullable final String protocol,
        @Nullable final String id,
        @Nullable final String recipient,
        final long timestamp)
    {
        this.from = from;
        this.by = by;
        this.byComment = byComment;
        this.protocol = protocol;
        this.id = id;
        this.recipient = recipient;
        this.timestamp = timestamp;
    }

    @NoAllocation
    @Nullable
    public ExtendedDomain from() {
        return from;
    }

    @NoAllocation
    @Nullable
    public ExtendedDomain by() {
        return by;
    }

    @NoAllocation
    @Nullable
    public String byComment() {
        return byComment;
    }

    @NoAllocation
    @Nullable
    public String protocol() {
        return protocol;
    }

    @NoAllocation
    @Nullable
    public String id() {
        return id;
    }

    @NoAllocation
    @Nullable
    public String recipient() {
        return recipient;
    }

    @NoAllocation
    public long timestamp() {
        return timestamp;
    }

    @NoAllocation
    @Override
    public int expectedStringLength() {
        int len = PREFIX_LENGTH + 6;
        len += StringBuilderable.calcExpectedStringLength(from);
        len += StringBuilderable.calcExpectedStringLength(by);
        len += StringBuilderable.calcExpectedStringLength(protocol);
        len += StringBuilderable.calcExpectedStringLength(id);
        len += StringBuilderable.calcExpectedStringLength(recipient);
        len += MAX_TIMESTAMP_LENGTH;
        return len;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append(PREFIX);
        StringBuilderable.toStringBuilder(sb, from);
        sb.append(',');
        StringBuilderable.toStringBuilder(sb, by);
        sb.append(',');
        sb.append(protocol);
        sb.append(',');
        sb.append(id);
        sb.append(',');
        sb.append(recipient);
        sb.append(',');
        sb.append(timestamp);
        sb.append(')');
    }
}

