package ru.yandex.parser.mail.received;

import java.net.InetAddress;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.NoAllocation;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.function.StringBuilderable;

@Immutable
public class TcpInfo extends AbstractStringBuilderable {
    private static final String PREFIX = "TcpInfo(";
    private static final int PREFIX_LENGTH = PREFIX.length();
    private static final int MAX_INET_ADDRESS_LENGTH = 39;

    @Nullable
    private final String domain;
    @Nonnull
    private final InetAddress address;

    public TcpInfo(
        @Nullable final String domain,
        @Nonnull final InetAddress address)
    {
        this.domain = domain;
        this.address = address;
    }

    @NoAllocation
    @Nullable
    public String domain() {
        return domain;
    }

    @NoAllocation
    @Nonnull
    public InetAddress address() {
        return address;
    }

    @NoAllocation
    @Override
    public int expectedStringLength() {
        return PREFIX_LENGTH
            + StringBuilderable.calcExpectedStringLength(domain)
            + MAX_INET_ADDRESS_LENGTH + 2;
    }

    @Override
    public void toStringBuilder(@Nonnull final StringBuilder sb) {
        sb.append(PREFIX);
        sb.append(domain);
        sb.append(',');
        sb.append(address.getHostAddress());
        sb.append(')');
    }
}

