JAVA_LIBRARY()

JDK_VERSION(11)

OWNER(g:so)

INCLUDE(${ARCADIA_ROOT}/mail/persdata/build/stricter_java_check.inc)

JAVA_SRCS(SRCDIR main/java **/*.java)

IF(YMAKE_JAVA_MODULES)
    RUN_PROGRAM(
        contrib/tools/ragel6 -J -o ${BINDIR}/generated/ReceivedParser.java
        mail/so/libs/java/received_parser/main/ragel/ru/yandex/parser/mail/received/ReceivedParser.rl
        IN mail/so/libs/java/received_parser/main/ragel/ru/yandex/parser/mail/received/ReceivedParser.rl
        OUT_NOAUTO ${BINDIR}/generated/ReceivedParser.java)
    JAVA_SRCS(SRCDIR ${BINDIR}/generated **/*.java)
ELSE()
    JAVA_SRCS(EXTERNAL mail/so/libs/java/received_parser/generated **/*.java)
    PEERDIR(mail/so/libs/java/received_parser/generated)
ENDIF()

PEERDIR(
    contrib/java/com/google/code/findbugs/jsr305
    contrib/java/com/google/errorprone/error_prone_annotations
    contrib/java/joda-time/joda-time
    mail/so/libs/java/smtp_envelope_parser
    mail/util/ip_utils
    mail/util/string_utils
    mail/util/url_processor
)

END()

RECURSE_FOR_TESTS(
    test
)

