package ru.yandex.expr_parser;

public class EmptyQueryVisitor<E extends Exception>
    implements QueryVisitor<Void, E>
{
    @Override
    public Void visit(final AndQuery query) throws E {
        visit(query.lhs());
        visit(query.rhs());
        return null;
    }

    @Override
    public Void visit(final OrQuery query) throws E {
        visit(query.lhs());
        visit(query.rhs());
        return null;
    }

    @Override
    public Void visit(final NotQuery query) throws E {
        visit(query.query());
        return null;
    }

    @Override
    public Void visit(final FieldQuery query) throws E {
        visit(query.query());
        return null;
    }

    @Override
    public Void visit(final StringQuery query) throws E {
        visit(query.query());
        return null;
    }

    @Override
    public Void visit(final ReQuery query) throws E {
        visit(query.query());
        return null;
    }
}

