package ru.yandex.expr_parser;

public class OrQuery implements QueryAtom {
    private final QueryAtom lhs;
    private final QueryAtom rhs;

    OrQuery(final QueryAtom lhs, final QueryAtom rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    QueryAtom lhs() {
        return lhs;
    }

    QueryAtom rhs() {
        return rhs;
    }

    @Override
    public <T, E extends Exception> T accept(final QueryVisitor<T, E> visitor)
        throws E
    {
        return visitor.visit(this);
    }
}

