package ru.yandex.expr_parser;

import java.util.function.Predicate;

public interface PredicateQueryVisitor<T, E extends Exception>
    extends QueryVisitor<Predicate<T>, E>
{
    default Predicate<T> visit(final AndQuery query) throws E {
        return query.lhs().accept(this).and(query.rhs().accept(this));
    }

    default Predicate<T> visit(final OrQuery query) throws E {
        return query.lhs().accept(this).or(query.rhs().accept(this));
    }

    default Predicate<T> visit(final NotQuery query) throws E {
        return query.query().accept(this).negate();
    }
}

