package ru.yandex.expr_parser;

import java.io.IOException;

public class QueryPrintingVisitor implements QueryVisitor<Void, IOException> {
    private final Appendable out;
    private int indent = 0;

    QueryPrintingVisitor(final Appendable out) {
        this.out = out;
    }

    private void op(final String op) throws IOException {
        for (int i = 0; i < indent; ++i) {
            out.append('\t');
        }
        out.append(op);
        out.append('\n');
    }

    @Override
    public Void visit(final QueryAtom query) throws IOException {
        ++indent;
        query.accept(this);
        --indent;
        return null;
    }

    @Override
    public Void visit(final AndQuery query) throws IOException {
        visit(query.lhs());
        op("AND");
        visit(query.rhs());
        return null;
    }

    @Override
    public Void visit(final OrQuery query) throws IOException {
        visit(query.lhs());
        op("OR");
        visit(query.rhs());
        return null;
    }

    @Override
    public Void visit(final NotQuery query) throws IOException {
        op("NOT");
        visit(query.query());
        return null;
    }

    @Override
    public Void visit(final FieldQuery query) throws IOException {
        op(query.field());
        return null;
    }

    @Override
    public Void visit(final StringQuery query) throws IOException {
        op(query.field());
        return null;
    }

    @Override
    public Void visit(final ReQuery query) throws IOException {
        op("RE");
        visit(query.query());
        return null;
    }
}

