package ru.yandex.expr_parser;

public interface QueryVisitor<T, E extends Exception> {
    default T visit(final QueryAtom query) throws E {
        return query.accept(this);
    }

    T visit(AndQuery query) throws E;

    T visit(OrQuery query) throws E;

    T visit(NotQuery query) throws E;

    T visit(FieldQuery query) throws E;

    T visit(StringQuery query) throws E;

    T visit(ReQuery query) throws E;
}

