package ru.yandex.expr_parser;

import ru.yandex.expr_parser.generated.Tokenizer;

public interface Token {
    enum Type implements Token {
        FIELD(true, 10),
        INTEGER(true, 10),
        DOUBLE(true, 10),
        STRING(true, 10),
        LPAR(false, 10),
        RPAR(false, 10),
        AND(false, 9),
        OR(false, 8),
        NOT(false, 10),
        WHITESPACE(false, 10),
        RE(false, 10),
        EOF(false, 10);

        private final boolean text;
        private final int precedence;

        Type(final boolean text, final int precedence) {
            this.text = text;
            this.precedence = precedence;
        }

        public Token createToken(final Tokenizer tokenizer) {
            if (text) {
                return new TextToken(
                    this,
                    tokenizer.yytext(),
                    tokenizer.pos());
            } else {
                return this;
            }
        }

        @Override
        public Type type() {
            return this;
        }

        public int precedence() {
            return precedence;
        }
    }

    Type type();

    default int pos() {
        return -1;
    }
}

