package ru.yandex.rules_parser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

import ru.yandex.parser.string.EnumParser;

public class Parser {
    public void parse(final List<String> lines) throws RuleException {
        for (final String line : lines) {
            parseLine(line.strip());
        }
    }

    enum KeyWord {
        RULE,
        RE,
        DESCRIBE,
        YASM,
        BEXPR,
        ARITHMETIC,
        FIELD,
        RCVDNUM,
        ;

        static KeyWord parse(String s) {
            return new EnumParser<>(KeyWord.class).apply(s);
        }
    }

    private void parseLine(final String line) throws RuleException {
        if (line.startsWith("#"))
            return;

        if (line.isEmpty()) {
            if (ruleParts != null) {
                final RawRule rawRule = new RawRule(ruleParts);
                ruleParts = null;
            }
            return;
        }

        final List<String> parts = Arrays.asList(line.split("\\s", 2));

        if (parts.size() < 2)
            return;

        final KeyWord key = KeyWord.parse(parts.get(0));

        if (key == KeyWord.RULE) {
            ruleParts = new HashMap<>();
        }
        ruleParts.put(key, parts.get(1));
    }

    private HashMap<KeyWord, String> ruleParts;
    LinkedList<Rule> rules = new LinkedList<>();
}
