package ru.yandex.expr_parser.generated;

import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Deque;

import ru.yandex.expr_parser.Token;

%%

%class Tokenizer
%public
%buffer 1024
%yylexthrow ParseException
%function nextToken
%type Token.Type
%eofval{
    return Token.Type.EOF;
%eofval}

%char
%{
    private final Deque<Integer> states = new ArrayDeque<>();

    public void state(final int state) {
        states.push(yystate());
        yybegin(state);
    }

    public void unstate() {
        yybegin(states.pop());
    }

    public int pos() {
        return (int) yychar;
    }
%}

Integer             = 0 | [1-9] [0-9]*
Exp                 = [eE] [+-]? [0-9]+
Double              = [-]? ({Integer} | [0-9]+ "." [0-9]* | "." [0-9]+) {Exp}

Re                  =  "RegexMatch"
String              = '([^\\']|\\.)*?'

FieldChar           = [\p{Alpha}\p{Digit}_-]
FirstFieldChar      = [\p{Alpha}\p{Digit}_]
Field               = {FirstFieldChar} {FieldChar}*

And                 = \s* ("AND" | "И" | "\&\&") \s*
Or                  = \s* ("OR" | "ИЛИ" | "\|\|") \s*
Not                 = (("NOT" | "НЕ" | "!") \s*)

%%

<YYINITIAL> {
    {Or}            {return Token.Type.OR;}
    ")"             {return Token.Type.RPAR;}

    \s+             {return Token.Type.WHITESPACE;}
    {And}           {return Token.Type.AND;}

    {Not}           {return Token.Type.NOT;}
    "("             {return Token.Type.LPAR;}
    {Re}            {return Token.Type.RE;}
    {String}        {return Token.Type.STRING;}
    {Field}         {return Token.Type.FIELD;}
}

[^]                 {
                        throw new ParseException(
                            "Could not match text '" + yytext()
                            + "' at pos: " + pos(),
                            pos());
                    }

