package ru.yandex.parser.mail.senders;

import java.util.Locale;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.util.string.StringUtils;

public enum SenderType {
    // From: with fallback to Reply-To:
    FROM {
        @Override
        public String extract(final SendersContext context) {
            return context.getSender();
        }

        @Override
        protected String id() {
            return "";
        }

        @Override
        public String longshinglerPrefix() {
            return "from-";
        }

        @Override
        public int shingleType() {
            return 260;
        }

        @Override
        public String emailField() {
            return "email";
        }

        @Override
        public String domainField() {
            return "domain";
        }
    },
    // Sender
    SENDER {
        @Override
        public String extract(final SendersContext context) {
            return context.getHdrSender();
        }

        @Override
        protected String id() {
            return "_sender";
        }

        @Override
        public String longshinglerPrefix() {
            return "beensender-";
        }

        @Override
        public int shingleType() {
            return 1028;
        }
    },
    // X-BeenThere
    X_BEENTHERE {
        @Override
        public String extract(final SendersContext context) {
            return context.extractFirstEmail("\nx-beenthere: ");
        }

        @Override
        protected String id() {
            return "_x_beenthere";
        }

        @Override
        public String longshinglerPrefix() {
            return "beensender-";
        }

        @Override
        public int shingleType() {
            return 1028;
        }
    },
    // List-Post
    LIST_POST {
        @Override
        public String extract(final SendersContext context) {
            return context.extractFirstEmail("\nlist-post: ");
        }

        @Override
        protected String id() {
            return "_list_post";
        }

        @Override
        public String longshinglerPrefix() {
            return "list-";
        }

        @Override
        public int shingleType() {
            return 1284;
        }
    },
    // List-Owner
    LIST_OWNER {
        @Override
        public String extract(final SendersContext context) {
            return context.extractFirstEmail("\nlist-owner: ");
        }

        @Override
        protected String id() {
            return "_list_owner";
        }

        @Override
        public String longshinglerPrefix() {
            return "list-";
        }

        @Override
        public int shingleType() {
            return 1284;
        }
    };

    private final String typeName = name().toLowerCase(Locale.ROOT);
    private final String sendersPrefix =
        StringUtils.concat("senders", id(), "_uid_");
    private final String sendersDomainPrefix =
        StringUtils.concat("senders_domain", id(), "_uid_");
    private final String pfiltersPrefix =
        StringUtils.concat("pfilters4", id(), '_');
    private final String tabPfPrefix = StringUtils.concat("tabpf", id(), '_');
    private final String emailField = typeName;
    private final String domainField = StringUtils.concat(typeName, "_domain");

    public String typeName() {
        return typeName;
    }

    // Headers is '\n' + meta.getLocal(HEADERS) + '\n', calculated once
    @Nullable
    public abstract String extract(@Nonnull SendersContext context);

    @Nonnull
    protected abstract String id();

    @Nonnull
    public abstract String longshinglerPrefix();

    public abstract int shingleType();

    // Can be used for senders url construction/detection
    // Use SendersContext.detectSenderType(...) for detection
    @Nonnull
    public String sendersPrefix() {
        return sendersPrefix;
    }

    @Nonnull
    public String sendersDomainPrefix() {
        return sendersDomainPrefix;
    }

    // Can be used for pfilters url construction
    // For pfilters detection use SendersContext.detectPfilterType(...)
    @Nonnull
    public String pfiltersPrefix() {
        return pfiltersPrefix;
    }

    @Nonnull
    public String tabPfPrefix() {
        return tabPfPrefix;
    }

    @Nonnull
    public String emailField() {
        return emailField;
    }

    @Nonnull
    public String domainField() {
        return domainField;
    }
}

