package ru.yandex.client.so.shingler;

import java.util.concurrent.Future;
import java.util.function.Supplier;

import javax.annotation.Nonnull;

import org.apache.http.HttpHost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.concurrent.CompletedFuture;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;

public abstract class AbstractShinglerClient<C extends AbstractAsyncClient<C>, R>
    extends AbstractAsyncClient<C>
{
    protected static final String OK = "OK";
    protected static final CompletedFuture<String> SUCCESS_PUT_RESULT = new CompletedFuture<>(OK);

    @Nonnull
    protected final HttpHost host;

    protected AbstractShinglerClient(
        @Nonnull final SharedConnectingIOReactor reactor,
        @Nonnull final ImmutableHttpHostConfig config)
    {
        super(reactor, config);
        host = config.host();
    }

    protected AbstractShinglerClient(
        @Nonnull final CloseableHttpAsyncClient client,
        @Nonnull final AbstractShinglerClient<C, R> sample)
    {
        super(client, sample);
        host = sample.host;
    }

    @Nonnull
    public Future<? extends R> getShingles(
        @Nonnull final AbstractShinglesMap<?> shingles,
        @Nonnull final FutureCallback<? super R> callback)
        throws ShinglerClientException, ShingleException
    {
        return getShingles(shingles, httpClientContextGenerator(), callback);
    }

    @Nonnull
    public abstract Future<? extends R> getShingles(
        @Nonnull final AbstractShinglesMap<?> shingles,
        @Nonnull final Supplier<? extends HttpClientContext> contextGenerator,
        @Nonnull final FutureCallback<? super R> callback) throws ShinglerClientException, ShingleException;

    @Nonnull
    public Future<String> putShingles(@Nonnull final R shinglesData)
        throws ShinglerClientException, ShingleException
    {
        return putShingles(shinglesData, httpClientContextGenerator(), StringFutureCallback.INSTANCE);
    }

    @Nonnull
    public Future<String> putShingles(
        @Nonnull final R shinglesData,
        @Nonnull final FutureCallback<String> callback)
        throws ShinglerClientException, ShingleException
    {
        return putShingles(shinglesData, httpClientContextGenerator(), callback);
    }

    @Nonnull
    public abstract Future<String> putShingles(
        @Nonnull final R shinglesData,
        @Nonnull final Supplier<? extends HttpClientContext> contextGenerator,
        @Nonnull final FutureCallback<String> callback) throws ShinglerClientException, ShingleException;

    public enum StringFutureCallback implements FutureCallback<String> {
        INSTANCE;

        @Override
        public void cancelled() {
        }

        @Override
        public void completed(final String result) {
        }

        @Override
        public void failed(final Exception e) {
        }
    }
}
