package ru.yandex.client.so.shingler;

import java.util.Map;

// all fields types must be matched to JsonObject.Type enum values
// accepted values: Long, ULong, Integer, Short, Byte, String, Boolean, Double
// Map (for predefined fields only)
public enum ActivityFieldSet implements FieldSet {
    ACT {
        @Override
        public Map<String, String> fields() {
            return Map.of(
                "uid", "ULong",
                "user_agent", "String",
                "last_dt", "ULong",
                "module", "String");
        }
    },
    COMPL {
        @Override
        public Map<String, String> fields() {
            return Map.of(
                "uid", "ULong",
                "lasttime", "Integer",
                "firsttime", "Integer",
                "days_with_complaints", "Integer",
                "complaints", "Long");
        }
    }
}
