package ru.yandex.client.so.shingler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

public enum ActivityScheme implements Scheme {
    ACTIVITY(SchemeType.DB, ActivityFieldSet.ACT, "uid"),
    COMPLS(SchemeType.DB, ActivityFieldSet.COMPL, "uid"),
    INC_COMPL_DAYS(SchemeType.DB, ActivityFieldSet.COMPL, "uid");

    private static final Map<String, Set<ActivityScheme>> fieldToScheme = new HashMap<>();

    private final SchemeType schemeType;
    private final ActivityFieldSet fieldSet;
    @SuppressWarnings("ImmutableEnumChecker")
    private final Set<String> keyFields;
    @SuppressWarnings("ImmutableEnumChecker")
    private final Map<String, ?> predefinedFields;

    static {
        for (ActivityScheme scheme : ActivityScheme.values()) {
            for (Map.Entry<String, String> entry : scheme.fields().entrySet()) {
                fieldToScheme.computeIfAbsent(entry.getKey(), x -> new HashSet<>()).add(scheme);
            }
        }
    }

    ActivityScheme(final SchemeType schemeType, final ActivityFieldSet fieldSet, final String... keyFields) {
        this.schemeType = schemeType;
        this.fieldSet = fieldSet;
        this.keyFields = Set.of(keyFields);
        predefinedFields = null;
    }

    @SuppressWarnings("unused")
    ActivityScheme(
        final SchemeType schemeType,
        final ActivityFieldSet fieldSet,
        final Map<String, ?> predefinedFields,
        final String... keyFields)
    {
        this.schemeType = schemeType;
        this.fieldSet = fieldSet;
        this.keyFields = Set.of(keyFields);
        this.predefinedFields = Map.copyOf(predefinedFields);
    }

    @Override
    public SchemeType schemeType() {
        return schemeType;
    }

    @Override
    public ActivityFieldSet fieldSet() {
        return fieldSet;
    }

    @Override
    public Map<String, String> fields() {
        return fieldSet.fields();
    }

    @Override
    public Map<String, ?> predefinedFields() {
        return predefinedFields;
    }

    @Override
    public Set<String> keyFields() {
        return keyFields;
    }

    @Override
    public Scheme fromName(String name) {
        return ActivityScheme.valueOf(name);
    }

    @Nonnull
    public static Set<ActivityScheme> schemesFromField(final String field) throws RuntimeException {
        Set<ActivityScheme> schemes = fieldToScheme.get(field);
        if (schemes == null) {
            throw new NullPointerException("ActivityScheme.schemesFromField returns null for field '" + field + "'");
        }
        return schemes;
    }

    @Override
    public String shingleField() {
        return "uid";
    }
}
