package ru.yandex.client.so.shingler;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;

public class ActivityShingleInfo extends EnumMap<ActivityScheme, Map<String, List<Object>>>
        implements GeneralShingleInfo<ActivityScheme>
{
    private static final long serialVersionUID = 0L;

    public ActivityShingleInfo() {
        super(ActivityScheme.class);
    }

    public ActivityShingleInfo(@Nonnull final Map<ActivityScheme, List<JsonMap>> jsonInfo)
        throws ShingleException
    {
        super(ActivityScheme.class);
        loadInfo(jsonInfo);
    }

    public ActivityShingleInfo(@Nonnull final ActivityScheme scheme, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(ActivityScheme.class);
        loadSchemeCounters(scheme, counters);
    }

    public ActivityShingleInfo(@Nonnull final Set<ActivityScheme> schemes, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(ActivityScheme.class);
        for (final ActivityScheme scheme : schemes) {
            loadSchemeCounters(scheme, counters);
        }
    }

    public ActivityShingleInfo(@Nonnull final ActivityScheme scheme, @Nonnull List<JsonMap> jsonCountersList)
        throws ShingleException
    {
        super(ActivityScheme.class);
        loadSchemeCounters(scheme, jsonCountersList);
    }

    public ActivityShingleInfo(@Nonnull final ActivityScheme scheme, @Nonnull JsonList jsonCountersList)
        throws ShingleException, JsonBadCastException
    {
        super(ActivityScheme.class);
        loadSchemeCounters(scheme, jsonCountersList);
    }

    public ActivityShingleInfo(@Nonnull final ActivityScheme scheme, @Nonnull JsonMap jsonCounters)
        throws ShingleException
    {
        super(ActivityScheme.class);
        loadSchemeCounters(scheme, jsonCounters);
    }

    public ActivityShingleInfo(
        @Nonnull final ActivityScheme scheme,
        @Nonnull final String counter,
        final long shingle)
        throws ShingleException
    {
        super(ActivityScheme.class);
        setSchemeCounter(scheme, counter, shingle);
    }

    public ActivityShingleInfo(final GeneralShingleInfo<ActivityScheme> shingleInfo) throws ShingleException {
        super(ActivityScheme.class);
        addInfo(shingleInfo);
    }

    @Override
    public ActivityShingleInfo copy() {
        try {
            return new ActivityShingleInfo(this);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean containsKey(ActivityScheme scheme) {
        return super.containsKey(scheme);
    }

    @Override
    public Map<String, List<Object>> get(ActivityScheme scheme) {
        return super.get(scheme);
    }

    @Override
    public Map<String, List<Object>> remove(ActivityScheme scheme) {
        return super.remove(scheme);
    }

    @Override
    public Map<String, List<Object>> computeIfAbsent(
            ActivityScheme scheme,
            Function<ActivityScheme, Map<String, List<Object>>> mappingFunction)
    {
        return super.computeIfAbsent(scheme, mappingFunction);
    }

    @Nonnull
    @Override
    public Set<ActivityScheme> keySet() {
        return super.keySet();
    }

    @Nonnull
    @Override
    public Set<Map.Entry<ActivityScheme, Map<String, List<Object>>>> entrySet() {
        return super.entrySet();
    }

    @Nonnull
    @Override
    public String name() {
        return "Activity";
    }
}
