package ru.yandex.client.so.shingler;

import javax.annotation.Nonnull;

import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class ActivityShinglerClient extends GeneralShinglerClient<ActivityScheme>
{
    public ActivityShinglerClient(
            @Nonnull final SharedConnectingIOReactor reactor,
            @Nonnull final ImmutableHttpHostConfig config)
    {
        super(reactor, config);
    }

    protected ActivityShinglerClient(
            @Nonnull final CloseableHttpAsyncClient client,
            @Nonnull final ActivityShinglerClient sample)
    {
        super(client, sample);
    }

    @Override
    public ActivityShinglerClient adjust(@Nonnull final CloseableHttpAsyncClient client) {
        return new ActivityShinglerClient(client, this);
    }

    @Override
    protected GeneralShingles<ActivityScheme> emptyResult() {
        return ActivityShingles.EMPTY;
    }

    @Override
    protected GeneralShingles<ActivityScheme> createShingles(@Nonnull final JsonObject jsonObject)
            throws JsonException, ShingleException
    {
        return new ActivityShingles(jsonObject);
    }

    protected static String name() {
        return "Activity";
    }
}
