package ru.yandex.client.so.shingler;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class ActivityShingles extends GeneralShingles<ActivityScheme>
{
    public static final ActivityShingles EMPTY = new ActivityShingles();

    private static final long serialVersionUID = 0L;
    private static final String NAME = "Activity";

    public ActivityShingles() {
        super();
    }

    public ActivityShingles(@Nonnull final JsonObject jsonResponse) throws JsonException, ShingleException
    {
        super(jsonResponse);
    }

    public ActivityShingles(@Nonnull final Map<ActivityScheme, List<JsonMap>> jsonInfo)
        throws JsonException, ShingleException
    {
        super(jsonInfo);
    }

    public ActivityShingles(@Nonnull final Set<ActivityScheme> schemes, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(schemes, counters);
    }

    public ActivityShingles(
        @Nonnull final Set<ActivityScheme> schemes,
        @Nonnull final List<Map<String, Object>> countersList)
        throws ShingleException
    {
        super(schemes, countersList);
    }

    public ActivityShingles(@Nonnull final ActivityScheme scheme, @Nonnull final List<JsonMap> jsonCountersList)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCountersList);
    }

    public ActivityShingles(@Nonnull final ActivityScheme scheme, @Nonnull final JsonList jsonCountersList)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCountersList);
    }

    public ActivityShingles(@Nonnull final JsonList jsonCountersList, @Nonnull final Set<ActivityScheme> schemes)
        throws JsonException, ShingleException
    {
        super(jsonCountersList, schemes);
    }

    public ActivityShingles(@Nonnull final ActivityScheme scheme, @Nonnull final JsonMap jsonCounters)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCounters);
    }

    public ActivityShingles(@Nonnull final Shingles shingles) throws ShingleException
    {
        super(shingles, ActivityScheme.schemesFromField(ActivityScheme.ACTIVITY.shingleField()));
    }

    public ActivityShingles(@Nonnull final GeneralShingles<ActivityScheme> shinglesInfo) throws ShingleException
    {
        super(shinglesInfo);
    }

    @Override
    public GeneralShingles<ActivityScheme> getEmpty() {
        return EMPTY;
    }

    @Override
    protected GeneralShingleInfo<ActivityScheme> createShingleInfo() {
        return new ActivityShingleInfo();
    }

    @Override
    protected GeneralShingleInfo<ActivityScheme> createShingleInfo(final Map<ActivityScheme, List<JsonMap>> jsonInfo)
        throws ShingleException
    {
        return new ActivityShingleInfo(jsonInfo);
    }

    @Override
    protected GeneralShingleInfo<ActivityScheme> createShingleInfo(
        @Nonnull final ActivityScheme scheme,
        @Nonnull List<JsonMap> jsonCountersList)
        throws ShingleException
    {
        return new ActivityShingleInfo(scheme, jsonCountersList);
    }

    @Override
    protected GeneralShingleInfo<ActivityScheme> createShingleInfo(
        final ActivityScheme scheme,
        final Map<String, Object> counters)
        throws ShingleException
    {
        return new ActivityShingleInfo(scheme, counters);
    }

    @Override
    protected GeneralShingleInfo<ActivityScheme> createShingleInfo(
        final Set<ActivityScheme> schemes,
        final Map<String, Object> counters)
        throws ShingleException
    {
        return new ActivityShingleInfo(schemes, counters);
    }

    @Override
    protected GeneralShingleInfo<ActivityScheme> createShingleInfo(
        @Nonnull final ActivityScheme scheme,
        @Nonnull final JsonList jsonCountersList)
        throws ShingleException, JsonBadCastException
    {
        return new ActivityShingleInfo(scheme, jsonCountersList);
    }

    @Override
    protected GeneralShingleInfo<ActivityScheme> createShingleInfo(
        @Nonnull final ActivityScheme scheme,
        @Nonnull final JsonMap jsonCounters)
        throws ShingleException, JsonException
    {
        return new ActivityShingleInfo(scheme, jsonCounters);
    }

    @Override
    protected GeneralShingleInfo<ActivityScheme> createShingleInfo(
        @Nonnull final ActivityScheme scheme,
        final long shingle)
        throws ShingleException
    {
        return new ActivityShingleInfo(scheme, scheme.shingleField(), shingle);
    }

    @Override
    protected GeneralShingleInfo<ActivityScheme> createShingleInfo(
        @Nonnull final GeneralShingleInfo<ActivityScheme> shingleInfo)
        throws ShingleException
    {
        return new ActivityShingleInfo(shingleInfo);
    }

    @Override
    protected ActivityScheme schemeFromName(final String schemeName) {
        return ActivityScheme.valueOf(schemeName);
    }

    @Override
    public String name() {
        return NAME;
    }
}
