package ru.yandex.client.so.shingler;

import java.util.Map;

import static java.util.Map.entry;

// all fields types must be matched to JsonObject.Type enum values
// accepted values: Long, ULong, Integer, Short, Byte, String, Boolean, Double
// Map (for predefined fields only)
public enum ComplFieldSet implements FieldSet {
    EMPTY {
        @Override
        public Map<String, String> fields() {
            return Map.of();
        }
    },
    TODAY_ABUSE {
        @Override
        public Map<String, String> fields() {
            return Map.ofEntries(
                entry("shingle", "ULong"),
                entry("type", "Byte"),
                entry("day", "Integer"),
                entry("ham", "Long"),
                entry("spam", "Long"),
                entry("malic", "Long"),
                entry("pers_ham", "Long"),
                entry("pers_spam", "Long"),
                entry("complaint_ham", "Long"),
                entry("complaint_spam", "Long"),
                entry("virus_count", "Long"),
                entry("uniq_sd_ham", "Long"),
                entry("uniq_sd_spam", "Long"),
                entry("expert_ham", "Long"),
                entry("expert_spam", "Long"));
        }
    },
    HISTORY_ABUSE {
        @Override
        public Map<String, String> fields() {
            return Map.ofEntries(
                entry("shingle", "ULong"),
                entry("type", "Byte"),
                entry("firsttime", "Integer"),
                entry("lasttime", "Integer"),
                entry("ham", "Long"),
                entry("spam", "Long"),
                entry("malic", "Long"),
                entry("pers_ham", "Long"),
                entry("pers_spam", "Long"),
                entry("complaint_ham", "Long"),
                entry("complaint_spam", "Long"),
                entry("virus_count", "Long"),
                entry("uniq_sd_ham", "Long"),
                entry("uniq_sd_spam", "Long"),
                entry("expert_ham", "Long"),
                entry("expert_spam", "Long"),
                entry("day_count_with_complaint", "Integer"),
                entry("virus_lasttime", "Integer"),
                entry("day_count_with_virus", "Integer"));
        }
    },
    USER_WEIGHTS {
        @Override
        public Map<String, String> fields() {
            return Map.ofEntries(
                entry("shingle", "ULong"),
                entry("type", "Byte"),
                entry("win_timeset", "Long"),
                entry("win_lastset", "Long"),
                entry("win_weight", "Double"),
                entry("win_setwghtcnt", "Integer"),
                entry("win_during", "Integer"),
                entry("win_user", "String"),
                entry("wout_timeset", "Long"),
                entry("wout_lastset", "Long"),
                entry("wout_weight", "Double"),
                entry("wout_setwghtcnt", "Integer"),
                entry("wout_during", "Integer"),
                entry("wout_user", "String"),
                entry("should_be_malic_in", "Integer"),
                entry("should_be_malic_out", "Integer"));
        }
    }
}
