package ru.yandex.client.so.shingler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

public enum ComplScheme implements Scheme {
    TODAY_ABUSES(SchemeType.DB, ComplFieldSet.TODAY_ABUSE, "shingle", "type"),
    HISTORY_ABUSES(SchemeType.DB, ComplFieldSet.HISTORY_ABUSE, "shingle", "type"),
    USER_WEIGHTS_ALL(SchemeType.DB, ComplFieldSet.USER_WEIGHTS),
    USER_WEIGHTS(SchemeType.DB, ComplFieldSet.USER_WEIGHTS, "shingle", "type"),
    HISTORY_ABUSES_DAYS(SchemeType.DB, ComplFieldSet.HISTORY_ABUSE, "shingle", "type", "lasttime"),
    HISTORY_VIRUS_DAYS(SchemeType.DB, ComplFieldSet.HISTORY_ABUSE, "shingle", "type", "virus_lasttime"),
    SHINGLE(SchemeType.SHINGLE_BY_TEXT, ComplFieldSet.EMPTY),
    OLDER(SchemeType.DB, ComplFieldSet.TODAY_ABUSE, "day");

    private static final Map<String, Set<ComplScheme>> fieldToScheme = new HashMap<>();

    private final SchemeType schemeType;
    private final ComplFieldSet fieldSet;
    @SuppressWarnings("ImmutableEnumChecker")
    private final Set<String> keyFields;
    @SuppressWarnings("ImmutableEnumChecker")
    private final Map<String, ?> predefinedFields;

    static {
        for (ComplScheme scheme : ComplScheme.values()) {
            for (Map.Entry<String, String> entry : scheme.fields().entrySet()) {
                fieldToScheme.computeIfAbsent(entry.getKey(), x -> new HashSet<>()).add(scheme);
            }
        }
    }

    ComplScheme(final SchemeType schemeType, final ComplFieldSet fieldSet, final String... keyFields) {
        this.schemeType = schemeType;
        this.fieldSet = fieldSet;
        this.keyFields = Set.of(keyFields);
        predefinedFields = null;
    }

    @SuppressWarnings("unused")
    ComplScheme(
        final SchemeType schemeType,
        final ComplFieldSet fieldSet,
        final Map<String, ?> predefinedFields,
        final String... keyFields)
    {
        this.schemeType = schemeType;
        this.fieldSet = fieldSet;
        this.keyFields = Set.of(keyFields);
        this.predefinedFields = Map.copyOf(predefinedFields);
    }

    @Override
    public SchemeType schemeType() {
        return schemeType;
    }

    @Override
    public ComplFieldSet fieldSet() {
        return fieldSet;
    }

    @Override
    public Map<String, String> fields() {
        return fieldSet.fields();
    }

    @Override
    public Map<String, ?> predefinedFields() {
        return predefinedFields;
    }

    @Override
    public Set<String> keyFields() {
        return keyFields;
    }

    @Override
    public Scheme fromName(String name) {
        return ComplScheme.valueOf(name);
    }

    @Nonnull
    public static Set<ComplScheme> schemesFromField(final String field) throws RuntimeException {
        Set<ComplScheme> schemes = fieldToScheme.get(field);
        if (schemes == null) {
            throw new NullPointerException("ComplScheme.schemesFromField returns null for field '" + field + "'");
        }
        return schemes;
    }

    @Override
    public String shingleField() {
        return "shingle";
    }

    @Override
    public String shingleTypeField() {
        return "type";
    }
}
