package ru.yandex.client.so.shingler;

import java.io.IOException;
import java.util.Map;

import javax.annotation.Nonnull;

import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.json.writer.JsonWriterBase;

public class ComplShinglerClient extends GeneralShinglerClient<ComplScheme>
{
    public ComplShinglerClient(
        @Nonnull final SharedConnectingIOReactor reactor,
        @Nonnull final ImmutableHttpHostConfig config)
    {
        super(reactor, config);
    }

    protected ComplShinglerClient(
        @Nonnull final CloseableHttpAsyncClient client,
        @Nonnull final ComplShinglerClient sample)
    {
        super(client, sample);
    }

    @Override
    public ComplShinglerClient adjust(@Nonnull final CloseableHttpAsyncClient client) {
        return new ComplShinglerClient(client, this);
    }

    @Override
    protected GeneralShingles<ComplScheme> emptyResult() {
        return ComplShingles.EMPTY;
    }

    @Override
    protected GeneralShingles<ComplScheme> createShingles(@Nonnull final JsonObject jsonObject)
            throws JsonException, ShingleException
    {
        return new ComplShingles(jsonObject);
    }

    protected static String name() {
        return "Compl";
    }

    public String getGetBasicQuery(@Nonnull final Map<ShingleType, Map<Long, Shingle>> shinglesStats) {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriterBase writer = (JsonWriterBase) JsonType.NORMAL.create(sbw)) {
            writer.startArray();
            writer.startObject();
            {
                writer.key("type");
                writer.value("Get");

                writer.key("scheme");
                writer.startArray();
                {
                    writer.value("history_abuses");
                    writer.value("today_abuses");
                    writer.value("user_weights");
                }
                writer.endArray();

                writer.key("fields");
                writer.startArray();
                {
                    writer.startObject();
                    {
                        writer.key("shingle");
                        {
                            writer.startArray();

                            for (Map.Entry<ShingleType, Map<Long, Shingle>> entry : shinglesStats.entrySet()) {
                                for (Long shingle : entry.getValue().keySet()) {
                                    writer.value(shingle, false, true);
                                }
                            }
                            writer.endArray();
                        }
                        writer.key("type");
                        {
                            writer.startArray();
                            for (Map.Entry<ShingleType, Map<Long, Shingle>> entry : shinglesStats.entrySet()) {
                                ShingleType type = entry.getKey();
                                for (int i = entry.getValue().size(); i-- > 0; ) {
                                    writer.value(type.id());
                                }
                            }
                            writer.endArray();
                        }
                    }
                    writer.endObject();
                }
                writer.endArray();
            }
            writer.endObject();
            writer.endArray();
        } catch (IOException e) {
            /*impossible*/
        }
        return sbw.toString();
    }

    public String getPutBasicQuery(@Nonnull final ComplShingles shinglesStats) {
        if (shinglesStats.size() < 1) {
            return null;
        }
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = JsonType.NORMAL.create(sbw)) {
            writer.startArray();
            writer.startObject();
            {
                writer.key("type");
                writer.value("Update");

                writer.key("scheme");
                writer.startArray();
                {
                    writer.value("today_abuses");
                    writer.value("history_abuses");
                }
                writer.endArray();

                writer.key("fields");
                writer.startArray();
                {
                    for (Map.Entry<ShingleType, Map<Long, GeneralShingleInfo<ComplScheme>>> entry
                            : shinglesStats.entrySet()) {
                        for (Map.Entry<Long, GeneralShingleInfo<ComplScheme>> shingleInfo
                                : entry.getValue().entrySet()) {
                            writer.startObject();
                            {
                                writer.key("shingle");
                                writer.value(shingleInfo.getKey());
                                writer.key("type");
                                writer.value(entry.getKey().id());
                                ComplShingleInfo.DailyStats todayStats =
                                    ((ComplShingleInfo) shingleInfo.getValue()).getTodayStats();
                                if (todayStats != null) {
                                    if (todayStats.getUniqSdSpam() > 0) {
                                        writer.key("uniq_sd_spam");
                                        writer.value(todayStats.getUniqSdSpam());
                                    }
                                    if (todayStats.getUniqSdHam() > 0) {
                                        writer.key("uniq_sd_ham");
                                        writer.value(todayStats.getUniqSdHam());
                                    }
                                    if (todayStats.getComplaintHam() > 0) {
                                        writer.key("complaint_ham");
                                        writer.value(todayStats.getComplaintHam());
                                    }
                                    if (todayStats.getComplaintSpam() > 0) {
                                        writer.key("complaint_spam");
                                        writer.value(todayStats.getComplaintSpam());
                                    }
                                }
                            }
                            writer.endObject();
                        }
                    }
                }
                writer.endArray();
            }
            writer.endObject();
            writer.startObject();
            {
                writer.key("type");
                writer.value("Update");

                writer.key("scheme");
                writer.startArray();
                {
                    writer.value("history_abuses_days");
                }
                writer.endArray();

                writer.key("fields");
                writer.startArray();
                {
                    for (Map.Entry<ShingleType, Map<Long, GeneralShingleInfo<ComplScheme>>> entry
                            : shinglesStats.entrySet()) {
                        for (Map.Entry<Long, GeneralShingleInfo<ComplScheme>> shingleInfo
                                : entry.getValue().entrySet()) {
                            writer.startObject();
                            {
                                writer.key("shingle");
                                writer.value(shingleInfo.getKey());
                                writer.key("type");
                                writer.value(entry.getKey().id());
                                writer.key("day_count_with_complaint");
                                writer.value(1);
                            }
                            writer.endObject();
                        }
                    }
                }
                writer.endArray();
            }
            writer.endObject();
            writer.endArray();
        } catch (IOException e) {
            /*impossible*/
        }
        return sbw.toString();
    }
}
