package ru.yandex.client.so.shingler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class ComplShingles extends GeneralShingles<ComplScheme>
{
    public static final ComplShingles EMPTY = new ComplShingles();

    private static final long serialVersionUID = 0L;
    private static final String NAME = "Compl";
    private static final String TYPE = "type";

    public ComplShingles() {
        super();
    }

    public ComplShingles(@Nonnull final JsonObject jsonResponse) throws JsonException, ShingleException
    {
        super(jsonResponse);
        correctShinglesTypes();
    }

    public ComplShingles(@Nonnull final Map<ComplScheme, List<JsonMap>> jsonInfo)
        throws JsonException, ShingleException
    {
        super(jsonInfo);
        correctShinglesTypes();
    }

    public ComplShingles(@Nonnull final Set<ComplScheme> schemes, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(schemes, counters);
        correctShinglesTypes();
    }

    public ComplShingles(@Nonnull final Set<ComplScheme> schemes, @Nonnull final List<Map<String, Object>> countersList)
        throws ShingleException
    {
        super(schemes, countersList);
    }

    public ComplShingles(@Nonnull final ComplScheme scheme, @Nonnull final List<JsonMap> jsonCountersList)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCountersList);
        correctShinglesTypes();
    }

    public ComplShingles(@Nonnull final ComplScheme scheme, @Nonnull final JsonList jsonCountersList)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCountersList);
        correctShinglesTypes();
    }

    public ComplShingles(@Nonnull final JsonList jsonCountersList, @Nonnull final Set<ComplScheme> schemes)
        throws JsonException, ShingleException
    {
        super(jsonCountersList, schemes);
        correctShinglesTypes();
    }

    public ComplShingles(@Nonnull final ComplScheme scheme, @Nonnull final JsonMap jsonCounters)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCounters);
        correctShinglesTypes();
    }

    public ComplShingles(@Nonnull final GeneralShingles<ComplScheme> shinglesInfo) throws ShingleException {
        super(shinglesInfo);
    }

    public ComplShingles(@Nonnull final Shingles shingles) throws ShingleException, RuntimeException {
        super(shingles, ComplScheme.schemesFromField(ComplScheme.TODAY_ABUSES.shingleField()));
    }

    @Override
    public GeneralShingles<ComplScheme> getEmpty() {
        return EMPTY;
    }

    @Override
    protected GeneralShingleInfo<ComplScheme> createShingleInfo() {
        return new ComplShingleInfo();
    }

    @Override
    protected GeneralShingleInfo<ComplScheme> createShingleInfo(final Map<ComplScheme, List<JsonMap>> jsonInfo)
        throws ShingleException
    {
        return new ComplShingleInfo(jsonInfo);
    }

    @Override
    protected GeneralShingleInfo<ComplScheme> createShingleInfo(
        @Nonnull final ComplScheme scheme,
        @Nonnull List<JsonMap> jsonCountersList)
        throws ShingleException
    {
        return new ComplShingleInfo(scheme, jsonCountersList);
    }

    @Override
    protected GeneralShingleInfo<ComplScheme> createShingleInfo(
        final ComplScheme scheme,
        final Map<String, Object> counters)
        throws ShingleException
    {
        return new ComplShingleInfo(scheme, counters);
    }

    @Override
    protected GeneralShingleInfo<ComplScheme> createShingleInfo(
        final Set<ComplScheme> schemes,
        final Map<String, Object> counters)
        throws ShingleException
    {
        return new ComplShingleInfo(schemes, counters);
    }

    @Override
    protected GeneralShingleInfo<ComplScheme> createShingleInfo(
        @Nonnull final ComplScheme scheme,
        @Nonnull final JsonList jsonCountersList)
        throws ShingleException, JsonBadCastException
    {
        return new ComplShingleInfo(scheme, jsonCountersList);
    }

    @Override
    protected GeneralShingleInfo<ComplScheme> createShingleInfo(
        @Nonnull final ComplScheme scheme,
        @Nonnull final JsonMap jsonCounters)
        throws ShingleException, JsonException
    {
        return new ComplShingleInfo(scheme, jsonCounters);
    }

    @Override
    protected GeneralShingleInfo<ComplScheme> createShingleInfo(
        @Nonnull final ComplScheme scheme,
        final long shingle)
        throws ShingleException
    {
        return new ComplShingleInfo(scheme, scheme.shingleField(), shingle);
    }

    @Override
    protected GeneralShingleInfo<ComplScheme> createShingleInfo(
        @Nonnull final GeneralShingleInfo<ComplScheme> shingleInfo)
        throws ShingleException
    {
        return new ComplShingleInfo(shingleInfo);
    }

    @SuppressWarnings("unused")
    public void addShingleInfo(final long shingle, final ComplScheme scheme, final Map<String, Object> counters)
        throws ShingleException
    {
        addShingleInfo(SHINGLE, shingle, scheme, counters);
    }

    @Override
    protected ComplScheme schemeFromName(final String schemeName) {
        return ComplScheme.valueOf(schemeName);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void loadCounters(@Nonnull Set<ComplScheme> schemes, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super.loadCounters(schemes, counters);
        for (Map.Entry<ShingleType, Map<Long, GeneralShingleInfo<ComplScheme>>> entry : entrySet()) {
            for (Map.Entry<Long, GeneralShingleInfo<ComplScheme>> shingleInfo : entry.getValue().entrySet()) {
                for (ComplScheme scheme : schemes) {
                    if (shingleInfo.getValue().containsKey(scheme)) {
                        Map<String, List<Object>> countersInfo = shingleInfo.getValue().get(scheme);
                        if (scheme.keyFields().contains(scheme.shingleField())) {
                            if (!countersInfo.containsKey(scheme.shingleField())) {
                                countersInfo.computeIfAbsent(scheme.shingleField(), x -> new ArrayList<>())
                                    .add(shingleInfo.getKey());
                            }
                            if (!countersInfo.containsKey(TYPE)) {
                                countersInfo.computeIfAbsent(TYPE, x -> new ArrayList<>())
                                    .add((byte) entry.getKey().id());
                            }
                        }
                    }
                }
            }
        }
    }

    private void correctShinglesTypes() throws ShingleException {
        int nSchemes = 0;
        if (containsKey(GeneralShingles.SHINGLE) && get(GeneralShingles.SHINGLE).size() > 0) {
            for (final Map.Entry<Long, GeneralShingleInfo<ComplScheme>> shingleInfo
                    : get(GeneralShingles.SHINGLE).entrySet())
            {
                for (final Map.Entry<ComplScheme, Map<String, List<Object>>> schemeCounters
                        : shingleInfo.getValue().entrySet())
                {
                    if (schemeCounters.getValue().containsKey(TYPE)) {
                        nSchemes += schemeCounters.getValue().get(TYPE).size();
                        for (int i = schemeCounters.getValue().get(TYPE).size() - 1; i >= 0; i--) {
                            final ShingleType shingleType =
                                ShingleType.fromId((byte) schemeCounters.getValue().get(TYPE).get(i));
                            if (shingleType != GeneralShingles.SHINGLE) {
                                final Map<String, Object> counters = new HashMap<>();
                                computeIfAbsent(shingleType, x -> new HashMap<>());
                                for (final Map.Entry<String, List<Object>> counterInfo
                                        : schemeCounters.getValue().entrySet())
                                {
                                    counters.put(counterInfo.getKey(), counterInfo.getValue().get(i));
                                }
                                if (get(shingleType).containsKey(shingleInfo.getKey())) {
                                    mergeShingleInfo(
                                        shingleType,
                                        shingleInfo.getKey(),
                                        schemeCounters.getKey(),
                                        counters);
                                } else {
                                    final ComplShingleInfo complShingleInfo =
                                        new ComplShingleInfo(schemeCounters.getKey(), counters);
                                    get(shingleType).put(shingleInfo.getKey(), complShingleInfo);
                                }
                                nSchemes--;
                            }
                        }
                    }
                }
            }
        }
        if (nSchemes < 1) {
            remove(GeneralShingles.SHINGLE);
        }
    }
}
