package ru.yandex.client.so.shingler;

import java.util.Map;

import static java.util.Map.entry;

// all fields types must be matched to JsonObject.Type enum values
// accepted values: Long, ULong, Integer, Short, Byte, String, Boolean, Double
// Map (for predefined fields only)
public enum FreemailFieldSet implements FieldSet {
    INFO {
        @Override
        public Map<String, String> fields() {
            return Map.of("uuid", "ULong",
                "date", "Integer",
                "create_date", "Integer",
                "active_days", "Integer");
        }
    },
    TIME {
        @Override
        public Map<String, String> fields() {
            return Map.of("uuid", "ULong",
                "date", "Integer");
        }
    },
    COUNTERS {
        @Override
        public Map<String, String> fields() {
            return Map.ofEntries(
                entry("uuid", "ULong"),
                entry("date", "Integer"),
                entry("send_ham", "Long"),
                entry("send_spam", "Long"),
                entry("receive_ham", "Long"),
                entry("receive_spam", "Long"),
                entry("complaint_ham", "Integer"),
                entry("complaint_spam", "Integer"),
                entry("recepients_count", "Long"),
                entry("recepients_max_count", "Long"),
                entry("current_day", "Integer"));
        }
    },
    RECIPIENTS_MAX {
        @Override
        public Map<String, String> fields() {
            return Map.of(
                "uuid", "ULong",
                "recepients_count", "Long",
                "recepients_max_count", "Map");
        }
    },
    COMPLAINT {
        @Override
        public Map<String, String> fields() {
            return Map.of("uuid", "ULong",
                "date", "Integer",
                "hash", "ULong",
                "spam", "Boolean");
        }
    },
    GEO {
        @Override
        public Map<String, String> fields() {
            return Map.of("uuid", "ULong",
                "date", "Integer",
                "geo", "String");
        }
    },
    BOUNCE {
        @Override
        public Map<String, String> fields() {
            return Map.of("uuid", "ULong",
                "date", "Integer",
                "today_spam", "Long",
                "today_unknown", "Long",
                "total_spam", "Long",
                "total_unknown", "Long",
                "last_type", "Byte");
        }
    },
    BOUNCE_TOTALS {
        @Override
        public Map<String, String> fields() {
            return Map.of("uuid", "ULong",
                "spam", "Long",
                "unknown", "Long",
                "last_type", "Byte");
        }
    },
    BOUNCE_HISTORY {
        @Override
        public Map<String, String> fields() {
            return Map.of("uuid", "ULong",
                "date", "Integer",
                "spam", "Long",
                "unknown", "Long",
                "last_type", "Byte");
        }
    },
    DOMAIN {
        @Override
        public Map<String, String> fields() {
            return Map.of("domain", "String",
                "date", "Integer",
                "count", "Integer");
        }
    },
    CURRENT {
        @Override
        public Map<String, String> fields() {
            return Map.of("day_from_millennium", "Integer");
        }
    },
    PDD {
        @Override
        public Map<String, String> fields() {
            return Map.of("request", "String",
                "param.domain", "String",
                "data", "String",
                "code", "Integer");
        }
    }
}
