package ru.yandex.client.so.shingler;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;

public class FreemailShingleInfo extends EnumMap<FreemailScheme, Map<String, List<Object>>>
    implements GeneralShingleInfo<FreemailScheme>
{
    private static final long serialVersionUID = 0L;

    public FreemailShingleInfo() {
        super(FreemailScheme.class);
    }

    public FreemailShingleInfo(@Nonnull final Map<FreemailScheme, List<JsonMap>> jsonInfo)
        throws ShingleException
    {
        super(FreemailScheme.class);
        loadInfo(jsonInfo);
    }

    public FreemailShingleInfo(@Nonnull final FreemailScheme scheme, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(FreemailScheme.class);
        loadSchemeCounters(scheme, counters);
    }

    public FreemailShingleInfo(@Nonnull final Set<FreemailScheme> schemes, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(FreemailScheme.class);
        for (final FreemailScheme scheme : schemes) {
            loadSchemeCounters(scheme, counters);
        }
    }

    public FreemailShingleInfo(@Nonnull final FreemailScheme scheme, @Nonnull List<JsonMap> jsonCountersList)
        throws ShingleException
    {
        super(FreemailScheme.class);
        loadSchemeCounters(scheme, jsonCountersList);
    }

    public FreemailShingleInfo(@Nonnull final FreemailScheme scheme, @Nonnull JsonList jsonCountersList)
        throws ShingleException, JsonBadCastException
    {
        super(FreemailScheme.class);
        loadSchemeCounters(scheme, jsonCountersList);
    }

    public FreemailShingleInfo(@Nonnull final FreemailScheme scheme, @Nonnull JsonMap jsonCounters)
        throws ShingleException
    {
        super(FreemailScheme.class);
        loadSchemeCounters(scheme, jsonCounters);
    }

    public FreemailShingleInfo(
        @Nonnull final FreemailScheme scheme,
        @Nonnull final String counter,
        final long shingle)
        throws ShingleException
    {
        super(FreemailScheme.class);
        setSchemeCounter(scheme, counter, shingle);
    }

    public FreemailShingleInfo(final GeneralShingleInfo<FreemailScheme> shingleInfo) throws ShingleException {
        super(FreemailScheme.class);
        addInfo(shingleInfo);
    }

    @Override
    public FreemailShingleInfo copy() {
        try {
            return new FreemailShingleInfo(this);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean containsKey(FreemailScheme scheme) {
        return super.containsKey(scheme);
    }

    @Override
    public Map<String, List<Object>> get(FreemailScheme scheme) {
        return super.get(scheme);
    }

    @Override
    public Map<String, List<Object>> remove(FreemailScheme scheme) {
        return super.remove(scheme);
    }

    @Override
    public Map<String, List<Object>> computeIfAbsent(
        FreemailScheme scheme,
        Function<FreemailScheme, Map<String, List<Object>>> mappingFunction)
    {
        return super.computeIfAbsent(scheme, mappingFunction);
    }

    @Nonnull
    @Override
    public Set<FreemailScheme> keySet() {
        return super.keySet();
    }

    @Nonnull
    @Override
    public Set<Map.Entry<FreemailScheme, Map<String, List<Object>>>> entrySet() {
        return super.entrySet();
    }

    @Nonnull
    @Override
    public String name() {
        return "Freemail";
    }
}
