package ru.yandex.client.so.shingler;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriterBase;

public class FreemailShinglerClient extends GeneralShinglerClient<FreemailScheme>
{
    public FreemailShinglerClient(
        @Nonnull final SharedConnectingIOReactor reactor,
        @Nonnull final ImmutableHttpHostConfig config)
    {
        super(reactor, config);
    }

    protected FreemailShinglerClient(
        @Nonnull final CloseableHttpAsyncClient client,
        @Nonnull final FreemailShinglerClient sample)
    {
        super(client, sample);
    }

    @Override
    public FreemailShinglerClient adjust(@Nonnull final CloseableHttpAsyncClient client) {
        return new FreemailShinglerClient(client, this);
    }

    @Override
    protected GeneralShingles<FreemailScheme> emptyResult() {
        return FreemailShingles.EMPTY;
    }

    @Override
    protected GeneralShingles<FreemailScheme> createShingles(@Nonnull final JsonObject jsonObject)
            throws JsonException, ShingleException
    {
        return new FreemailShingles(jsonObject);
    }

    protected static String name() {
        return "Freemail";
    }

    public String getPutQuery(@Nonnull final FreemailShingles shingles, boolean schemesGroupping)
        throws ShingleException
    {
        StringBuilderWriter sbw = new StringBuilderWriter();
        if (shingles.size() < 1) {
            return sbw.toString();
        }
        final Map<FreemailScheme, Map<String, List<Object>>> countersInfo = new HashMap<>();
        final Map<Set<String>, Set<FreemailScheme>> data = getSchemesByCounters(shingles, countersInfo);
        try (JsonWriterBase writer = (JsonWriterBase) JsonType.NORMAL.create(sbw)) {
            writer.startArray();
            for (final Map.Entry<Set<String>, Set<FreemailScheme>> entry : data.entrySet()) {
                writePutQueryHelper2(writer, countersInfo, entry.getValue(), entry.getKey(), schemesGroupping);
            }
            if (shingles.addonShingles() != null && shingles.addonShingles().size() > 0) {
                final Map<FreemailScheme, Map<String, List<Object>>> countersInfo2 = new HashMap<>();
                final Map<Set<String>, Set<FreemailScheme>> data2 =
                    getSchemesByCounters(shingles.addonShingles(), countersInfo2);
                for (final Map.Entry<Set<String>, Set<FreemailScheme>> entry : data2.entrySet()) {
                    writePutQueryHelper2(writer, countersInfo2, entry.getValue(), entry.getKey(), schemesGroupping);
                }
            }
            writer.endArray();
        } catch (IOException e) {
            /*impossible*/
        }
        return sbw.toString();
    }
}
