package ru.yandex.client.so.shingler;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.digest.Fnv;
import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

// shingle is user's UID
public class FreemailShingles extends GeneralShingles<FreemailScheme>
{
    public static final FreemailShingles EMPTY = new FreemailShingles();
    private static final long serialVersionUID = 0L;
    private static final String NAME = "Freemail";
    private FreemailShingles addonShingles = null;

    public FreemailShingles() {
        super();
    }

    public FreemailShingles(@Nonnull final JsonObject jsonResponse) throws JsonException, ShingleException
    {
        super(jsonResponse);
    }

    public FreemailShingles(@Nonnull final Map<FreemailScheme, List<JsonMap>> jsonInfo)
        throws JsonException, ShingleException
    {
        super(jsonInfo);
    }

    public FreemailShingles(@Nonnull final Set<FreemailScheme> schemes, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(schemes, counters);
    }

    public FreemailShingles(
        @Nonnull final Set<FreemailScheme> schemes,
        @Nonnull final List<Map<String, Object>> countersList)
        throws ShingleException
    {
        super(schemes, countersList);
    }

    public FreemailShingles(@Nonnull final FreemailScheme scheme, @Nonnull final List<JsonMap> jsonCountersList)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCountersList);
    }

    public FreemailShingles(@Nonnull final FreemailScheme scheme, @Nonnull final JsonList jsonCountersList)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCountersList);
    }

    public FreemailShingles(@Nonnull final JsonList jsonCountersList, @Nonnull final Set<FreemailScheme> schemes)
        throws JsonException, ShingleException
    {
        super(jsonCountersList, schemes);
    }

    public FreemailShingles(@Nonnull final FreemailScheme scheme, @Nonnull final JsonMap jsonCounters)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCounters);
    }

    public FreemailShingles(@Nonnull final GeneralShingles<FreemailScheme> shinglesInfo) throws ShingleException {
        super(shinglesInfo);
        copyAddonShingles((FreemailShingles) shinglesInfo);
    }

    public FreemailShingles(@Nonnull final Shingles shingles) throws ShingleException, RuntimeException {
        super(shingles, FreemailScheme.schemesFromField(FreemailScheme.COUNTERS.shingleField()));
    }

    @Override
    public GeneralShingles<FreemailScheme> getEmpty() {
        return EMPTY;
    }

    @Override
    protected GeneralShingleInfo<FreemailScheme> createShingleInfo() {
        return new FreemailShingleInfo();
    }

    @Override
    protected GeneralShingleInfo<FreemailScheme> createShingleInfo(
        @Nonnull final Map<FreemailScheme, List<JsonMap>> jsonInfo)
        throws ShingleException
    {
        return new FreemailShingleInfo(jsonInfo);
    }

    @Override
    protected GeneralShingleInfo<FreemailScheme> createShingleInfo(
        @Nonnull final FreemailScheme scheme,
        @Nonnull final List<JsonMap> jsonCountersList)
        throws ShingleException
    {
        return new FreemailShingleInfo(scheme, jsonCountersList);
    }

    @Override
    protected GeneralShingleInfo<FreemailScheme> createShingleInfo(
        final FreemailScheme scheme,
        final Map<String, Object> counters)
        throws ShingleException
    {
        return new FreemailShingleInfo(scheme, counters);
    }

    @Override
    protected GeneralShingleInfo<FreemailScheme> createShingleInfo(
        final Set<FreemailScheme> schemes,
        final Map<String, Object> counters)
        throws ShingleException
    {
        return new FreemailShingleInfo(schemes, counters);
    }

    @Override
    protected GeneralShingleInfo<FreemailScheme> createShingleInfo(
        @Nonnull final FreemailScheme scheme,
        @Nonnull final JsonList jsonCountersList)
        throws ShingleException, JsonBadCastException
    {
        return new FreemailShingleInfo(scheme, jsonCountersList);
    }

    @Override
    protected GeneralShingleInfo<FreemailScheme> createShingleInfo(
        @Nonnull final FreemailScheme scheme,
        @Nonnull final JsonMap jsonCounters)
        throws ShingleException, JsonException
    {
        return new FreemailShingleInfo(scheme, jsonCounters);
    }

    @Override
    protected GeneralShingleInfo<FreemailScheme> createShingleInfo(
        @Nonnull final FreemailScheme scheme,
        final long shingle)
        throws ShingleException
    {
        return new FreemailShingleInfo(scheme, scheme.shingleField(), shingle);
    }

    @Override
    protected GeneralShingleInfo<FreemailScheme> createShingleInfo(
        @Nonnull final GeneralShingleInfo<FreemailScheme> shingleInfo)
        throws ShingleException
    {
        return new FreemailShingleInfo(shingleInfo);
    }

    @Override
    protected FreemailScheme schemeFromName(final String schemeName) {
        return FreemailScheme.valueOf(schemeName);
    }

    @Override
    public String name() {
        return NAME;
    }

    public static long hash(final String value, boolean isYandex) {
        return isYandex ? Fnv.fnv64(value) : (Fnv.fnv64(value) ^ intHash(1));
    }

    private static long intHash(final long value) {
        long key = value;
        key += ~(key << 32);
        key ^= (key >> 22);
        key += ~(key << 13);
        key ^= (key >> 8);
        key += (key << 3);
        key ^= (key >> 15);
        key += ~(key << 27);
        key ^= (key >> 31);

        return key;
    }

    public FreemailShingles addonShingles() {
        return addonShingles;
    }

    @SuppressWarnings("unused")
    public void setAddonShingles(final FreemailShingles shingles) {
        addonShingles = shingles;
    }

    @Override
    public void addAll(final AbstractShinglesMap<?> data) throws ShingleException {
        super.addAll(data);
        copyAddonShingles((FreemailShingles) data);
    }

    private void copyAddonShingles(final FreemailShingles data) throws ShingleException {
        final FreemailShingles auxiliaryShingles = data.addonShingles();
        if (auxiliaryShingles != null) {
            if (addonShingles == null) {
                addonShingles = new FreemailShingles();
            }
            addonShingles.addAll(auxiliaryShingles);
        }
    }
}
