package ru.yandex.client.so.shingler;

import javax.annotation.Nonnull;

import com.google.errorprone.annotations.NoAllocation;

import ru.yandex.function.AbstractStringBuilderable;

public class MassShingleResult extends AbstractStringBuilderable {
    private static final String PREFIX = "MassShingleResult(";
    private static final int PREFIX_LENGTH = PREFIX.length();

    @Nonnull
    private final Shingle shingle;
    @Nonnull
    private final MassShingleInfo shingleInfo;

    public MassShingleResult(
        @Nonnull final Shingle shingle,
        @Nonnull final MassShingleInfo shingleInfo)
    {
        this.shingle = shingle;
        this.shingleInfo = shingleInfo;
    }

    @NoAllocation
    @Nonnull
    public Shingle shingle() {
        return shingle;
    }

    @NoAllocation
    @Nonnull
    public MassShingleInfo shingleInfo() {
        return shingleInfo;
    }

    @NoAllocation
    @Override
    public int expectedStringLength() {
        return PREFIX_LENGTH
            + 2
            + shingle.expectedStringLength()
            + shingleInfo.expectedStringLength();
    }

    @Override
    public void toStringBuilder(@Nonnull final StringBuilder sb) {
        sb.append(PREFIX);
        shingle.toStringBuilder(sb);
        sb.append(',');
        shingleInfo.toStringBuilder(sb);
        sb.append(')');
    }
}

