package ru.yandex.client.so.shingler;

import java.util.Map;

import static java.util.Map.entry;

// all fields types must be matched to JsonObject.Type enum values
// accepted values: Long, ULong, Integer, Short, Byte, String, Boolean, Double
// Map (for predefined fields only)
public enum SenderFieldSet  implements FieldSet {
    SENDER_TOTALS {
        @Override
        public Map<String, String> fields() {
            return Map.ofEntries(
                entry("hash", "ULong"),
                entry("sendertype", "Byte"),
                entry("ad", "ULong"),
                entry("ct", "Integer"),
                entry("ut", "Integer"),
                entry("hc", "ULong"),
                entry("sc", "ULong"),
                entry("ry", "ULong"),
                entry("ch", "ULong"),
                entry("cs", "ULong"),
                entry("fl", "ULong"),
                entry("ph", "ULong"),
                entry("ps", "ULong"),
                entry("ab", "ULong"),
                entry("ba", "ULong"),
                entry("c1", "ULong"),
                entry("c2", "ULong"),
                entry("read", "ULong"),
                entry("deleted", "ULong"),
                entry("dkim_spam", "ULong"),
                entry("dkim_ham", "ULong"),
                entry("pop3_spam", "ULong"),
                entry("pop3_ham", "ULong"),
                entry("dkim_complaint_spam", "ULong"),
                entry("dkim_del", "ULong"),
                entry("ps_ham", "ULong"),
                entry("ps_spam", "ULong"));
        }
    },
    SENDER_2WEEKS {
        @Override
        public Map<String, String> fields() {
            return Map.ofEntries(
                entry("hash", "ULong"),
                entry("sendertype", "Byte"),
                entry("ham", "Long"),
                entry("spam", "Long"),
                entry("compl_ham", "Long"),
                entry("compl_spam", "Long"),
                entry("pers_ham", "Long"),
                entry("pers_spam", "Long"),
                entry("abook", "Long"),
                entry("kooba", "Long"),
                entry("read", "Long"),
                entry("deleted", "Long"),
                entry("dkim_spam", "Long"),
                entry("dkim_ham", "Long"),
                entry("dkim_del", "Long"),
                entry("ps_ham", "Long"),
                entry("ps_spam", "Long"),
                entry("week", "Integer"));
        }
    }
}
