package ru.yandex.client.so.shingler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

public enum SenderScheme implements Scheme {
    SENDER_2WEEKS(SchemeType.DB, SenderFieldSet.SENDER_2WEEKS, "hash", "sendertype", "week"),
    SENDER_TOTALS(SchemeType.DB, SenderFieldSet.SENDER_TOTALS, "hash", "sendertype"),
    SENDER_AD(SchemeType.DB, SenderFieldSet.SENDER_TOTALS, "hash", "sendertype", "ut"),
    OLDER(SchemeType.DB, SenderFieldSet.SENDER_2WEEKS, "week");

    private static final Map<String, Set<SenderScheme>> fieldToScheme = new HashMap<>();

    private final SchemeType schemeType;
    private final SenderFieldSet fieldSet;
    @SuppressWarnings("ImmutableEnumChecker")
    private final Set<String> keyFields;
    @SuppressWarnings("ImmutableEnumChecker")
    private final Map<String, ?> predefinedFields;

    static {
        for (SenderScheme scheme : SenderScheme.values()) {
            for (Map.Entry<String, String> entry : scheme.fields().entrySet()) {
                fieldToScheme.computeIfAbsent(entry.getKey(), x -> new HashSet<>()).add(scheme);
            }
        }
    }

    SenderScheme(final SchemeType schemeType, final SenderFieldSet fieldSet, final String... keyFields) {
        this.schemeType = schemeType;
        this.fieldSet = fieldSet;
        this.keyFields = Set.of(keyFields);
        predefinedFields = null;
    }

    @SuppressWarnings("unused")
    SenderScheme(
        final SchemeType schemeType,
        final SenderFieldSet fieldSet,
        final Map<String, ?> predefinedFields,
        final String... keyFields)
    {
        this.schemeType = schemeType;
        this.fieldSet = fieldSet;
        this.keyFields = Set.of(keyFields);
        this.predefinedFields = Map.copyOf(predefinedFields);
    }

    @Override
    public SchemeType schemeType() {
        return schemeType;
    }

    @Override
    public SenderFieldSet fieldSet() {
        return fieldSet;
    }

    @Override
    public Map<String, String> fields() {
        return fieldSet.fields();
    }

    @Override
    public Map<String, ?> predefinedFields() {
        return predefinedFields;
    }

    @Override
    public Set<String> keyFields() {
        return keyFields;
    }

    @Override
    public Scheme fromName(String name) {
        return SenderScheme.valueOf(name);
    }

    @Nonnull
    public static Set<SenderScheme> schemesFromField(final String field) throws RuntimeException {
        Set<SenderScheme> schemes = fieldToScheme.get(field);
        if (schemes == null) {
            throw new NullPointerException("SenderScheme.schemesFromField returns null for field '" + field + "'");
        }
        return schemes;
    }

    @Override
    public String shingleField() {
        return "hash";
    }

    @Override
    public String shingleTypeField() {
        return "sendertype";
    }
}
