package ru.yandex.client.so.shingler;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;

public class SenderShingleInfo extends EnumMap<SenderScheme, Map<String, List<Object>>>
    implements GeneralShingleInfo<SenderScheme>
{
    private static final long serialVersionUID = 0L;

    public SenderShingleInfo() {
        super(SenderScheme.class);
    }

    public SenderShingleInfo(@Nonnull final Map<SenderScheme, List<JsonMap>> jsonInfo)
        throws ShingleException
    {
        super(SenderScheme.class);
        loadInfo(jsonInfo);
    }

    public SenderShingleInfo(@Nonnull final SenderScheme scheme, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(SenderScheme.class);
        loadSchemeCounters(scheme, counters);
    }

    public SenderShingleInfo(@Nonnull final Set<SenderScheme> schemes, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(SenderScheme.class);
        for (final SenderScheme scheme : schemes) {
            loadSchemeCounters(scheme, counters);
        }
    }

    public SenderShingleInfo(@Nonnull final SenderScheme scheme, @Nonnull List<JsonMap> jsonCountersList)
        throws ShingleException
    {
        super(SenderScheme.class);
        loadSchemeCounters(scheme, jsonCountersList);
    }

    public SenderShingleInfo(@Nonnull final SenderScheme scheme, @Nonnull JsonList jsonCountersList)
        throws ShingleException, JsonBadCastException
    {
        super(SenderScheme.class);
        loadSchemeCounters(scheme, jsonCountersList);
    }

    public SenderShingleInfo(@Nonnull final SenderScheme scheme, @Nonnull JsonMap jsonCounters)
        throws ShingleException
    {
        super(SenderScheme.class);
        loadSchemeCounters(scheme, jsonCounters);
    }

    public SenderShingleInfo(@Nonnull final SenderScheme scheme, @Nonnull final String counter, final long shingle)
        throws ShingleException
    {
        super(SenderScheme.class);
        setSchemeCounter(scheme, counter, shingle);
    }

    public SenderShingleInfo(final GeneralShingleInfo<SenderScheme> shingleInfo) throws ShingleException {
        super(SenderScheme.class);
        addInfo(shingleInfo);
    }

    @Override
    public SenderShingleInfo copy() {
        try {
            return new SenderShingleInfo(this);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean containsKey(SenderScheme scheme) {
        return super.containsKey(scheme);
    }

    @Override
    public Map<String, List<Object>> get(SenderScheme scheme) {
        return super.get(scheme);
    }

    @Override
    public Map<String, List<Object>> remove(SenderScheme scheme) {
        return super.remove(scheme);
    }

    @Override
    public Map<String, List<Object>> computeIfAbsent(
        SenderScheme scheme,
        Function<SenderScheme, Map<String, List<Object>>> mappingFunction)
    {
        return super.computeIfAbsent(scheme, mappingFunction);
    }

    @Nonnull
    @Override
    public Set<SenderScheme> keySet() {
        return super.keySet();
    }

    @Nonnull
    @Override
    public Set<Map.Entry<SenderScheme, Map<String, List<Object>>>> entrySet() {
        return super.entrySet();
    }

    @Nonnull
    @Override
    public String name() {
        return "Sender";
    }
}
