package ru.yandex.client.so.shingler;

import javax.annotation.Nonnull;

import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class SenderShinglerClient extends GeneralShinglerClient<SenderScheme>
{
    public SenderShinglerClient(
        @Nonnull final SharedConnectingIOReactor reactor,
        @Nonnull final ImmutableHttpHostConfig config)
    {
        super(reactor, config);
    }

    protected SenderShinglerClient(
        @Nonnull final CloseableHttpAsyncClient client,
        @Nonnull final SenderShinglerClient sample)
    {
        super(client, sample);
    }

    @Override
    public SenderShinglerClient adjust(@Nonnull final CloseableHttpAsyncClient client) {
        return new SenderShinglerClient(client, this);
    }

    @Override
    protected GeneralShingles<SenderScheme> emptyResult() {
        return SenderShingles.EMPTY;
    }

    @Override
    protected GeneralShingles<SenderScheme> createShingles(@Nonnull final JsonObject jsonObject)
        throws JsonException, ShingleException
    {
        return new SenderShingles(jsonObject);
    }

    protected static String name() {
        return "Sender";
    }
}
