package ru.yandex.client.so.shingler;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class SenderShingles extends GeneralShingles<SenderScheme>
{
    public static final SenderShingles EMPTY = new SenderShingles();

    private static final long serialVersionUID = 0L;
    private static final String NAME = "Sender";

    public SenderShingles() {
        super();
    }

    public SenderShingles(@Nonnull final JsonObject jsonResponse) throws JsonException, ShingleException
    {
        super(jsonResponse);
    }

    public SenderShingles(@Nonnull final Map<SenderScheme, List<JsonMap>> jsonInfo)
        throws JsonException, ShingleException
    {
        super(jsonInfo);
    }

    public SenderShingles(@Nonnull final Set<SenderScheme> schemes, @Nonnull final Map<String, Object> counters)
        throws ShingleException
    {
        super(schemes, counters);
    }

    public SenderShingles(
        @Nonnull final Set<SenderScheme> schemes,
        @Nonnull final List<Map<String, Object>> countersList)
        throws ShingleException
    {
        super(schemes, countersList);
    }

    public SenderShingles(@Nonnull final SenderScheme scheme, @Nonnull final List<JsonMap> jsonCountersList)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCountersList);
    }

    public SenderShingles(@Nonnull final SenderScheme scheme, @Nonnull final JsonList jsonCountersList)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCountersList);
    }

    public SenderShingles(@Nonnull final JsonList jsonCountersList, @Nonnull final Set<SenderScheme> schemes)
        throws JsonException, ShingleException
    {
        super(jsonCountersList, schemes);
    }

    public SenderShingles(@Nonnull final SenderScheme scheme, @Nonnull final JsonMap jsonCounters)
        throws JsonException, ShingleException
    {
        super(scheme, jsonCounters);
    }

    public SenderShingles(@Nonnull final GeneralShingles<SenderScheme> shinglesInfo) throws ShingleException {
        super(shinglesInfo);
    }

    public SenderShingles(@Nonnull final Shingles shingles) throws ShingleException, RuntimeException {
        super(shingles, SenderScheme.schemesFromField(SenderScheme.SENDER_TOTALS.shingleField()));
    }

    @Override
    public GeneralShingles<SenderScheme> getEmpty() {
        return EMPTY;
    }

    @Override
    protected GeneralShingleInfo<SenderScheme> createShingleInfo() {
        return new SenderShingleInfo();
    }

    @Override
    protected GeneralShingleInfo<SenderScheme> createShingleInfo(final Map<SenderScheme, List<JsonMap>> jsonInfo)
        throws ShingleException
    {
        return new SenderShingleInfo(jsonInfo);
    }

    @Override
    protected GeneralShingleInfo<SenderScheme> createShingleInfo(
        @Nonnull final SenderScheme scheme,
        @Nonnull List<JsonMap> jsonCountersList)
        throws ShingleException
    {
        return new SenderShingleInfo(scheme, jsonCountersList);
    }

    @Override
    protected GeneralShingleInfo<SenderScheme> createShingleInfo(
        final SenderScheme scheme,
        final Map<String, Object> counters)
        throws ShingleException
    {
        return new SenderShingleInfo(scheme, counters);
    }

    @Override
    protected GeneralShingleInfo<SenderScheme> createShingleInfo(
        final Set<SenderScheme> schemes,
        final Map<String, Object> counters)
        throws ShingleException
    {
        return new SenderShingleInfo(schemes, counters);
    }

    @Override
    protected GeneralShingleInfo<SenderScheme> createShingleInfo(
        @Nonnull final SenderScheme scheme,
        @Nonnull final JsonList jsonCountersList)
        throws ShingleException, JsonBadCastException
    {
        return new SenderShingleInfo(scheme, jsonCountersList);
    }

    @Override
    protected GeneralShingleInfo<SenderScheme> createShingleInfo(
        @Nonnull final SenderScheme scheme,
        @Nonnull final JsonMap jsonCounters)
        throws ShingleException, JsonException
    {
        return new SenderShingleInfo(scheme, jsonCounters);
    }

    @Override
    protected GeneralShingleInfo<SenderScheme> createShingleInfo(
        @Nonnull final SenderScheme scheme,
        final long shingle)
        throws ShingleException
    {
        return new SenderShingleInfo(scheme, scheme.shingleField(), shingle);
    }

    @Override
    protected GeneralShingleInfo<SenderScheme> createShingleInfo(
        @Nonnull final GeneralShingleInfo<SenderScheme> shingleInfo)
        throws ShingleException
    {
        return new SenderShingleInfo(shingleInfo);
    }

    @Override
    protected SenderScheme schemeFromName(final String schemeName) {
        return SenderScheme.valueOf(schemeName);
    }

    @Override
    public String name() {
        return NAME;
    }

    @SuppressWarnings("unused")
    public void addShingleInfo(final long shingle, final SenderScheme scheme, final Map<String, Object> counters)
        throws ShingleException
    {
        addShingleInfo(SHINGLE, shingle, scheme, counters);
    }
}
