package ru.yandex.client.so.shingler;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import com.google.errorprone.annotations.NoAllocation;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonObject;

public class Shingle extends AbstractStringBuilderable {
    private static final String PREFIX = "Shingle(";
    private static final int PREFIX_LENGTH = PREFIX.length();

    private final long shingleHash;
    @Nonnull
    private final Map<String, int[]> values = new HashMap<>();
    private int count = 0;

    public Shingle(final long shingleHash) {
        this.shingleHash = shingleHash;
    }

    public Shingle(final Shingle other) {
        shingleHash = other.shingleHash();
        count = other.count();
        values.putAll(other.values);
    }

    public Shingle(final JsonObject jsonHashValue) throws JsonBadCastException {
        this(jsonHashValue.asString());
    }

    public Shingle(final String hashValue) {
        this.shingleHash = Long.parseUnsignedLong(hashValue, 16);
    }

    @NoAllocation
    public long shingleHash() {
        return shingleHash;
    }

    public Set<String> values() {
        return values.keySet();
    }

    @NoAllocation
    public int count() {
        return count;
    }

    @NoAllocation
    public void setCount(final int count) {
        this.count = count;
    }

    @NoAllocation
    public int count(@Nonnull final String value) {
        int[] count = values.get(value);
        if (count == null) {
            return 0;
        } else {
            return count[0];
        }
    }

    public void add(@Nonnull final String value) {
        ++values.computeIfAbsent(value, x -> new int[1])[0];
        ++count;
    }

    @Override
    public int expectedStringLength() {
        int len = PREFIX_LENGTH
            + 3
            + MAX_INT_LENGTH
            + values.size() * (MAX_INT_LENGTH + 2);
        for (Map.Entry<String, int[]> entry: values.entrySet()) {
            len += entry.getKey().length();
        }
        return len;
    }

    @Override
    public void toStringBuilder(@Nonnull final StringBuilder sb) {
        sb.append(PREFIX);
        sb.append(count);
        sb.append(',');
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, int[]> entry: values.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue()[0]);
        }
        sb.append('}');
        sb.append(')');
    }
}

