package ru.yandex.client.so.shingler;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.errorprone.annotations.NoAllocation;

public enum ShingleType {
    // detail description see here: https://wiki.yandex-team.ru/AntiSpam/MailAnalysts/#tipyshinglov
    UNKNOWN(0),
    FULL_TEXT_SHINGLE(1),
    CLEAR_TEXT_SHINGLE(2),
    HTML_TEXT_SHINGLE(3),
    PHONE_SHINGLE(4),
    NUMBER_SHINGLE(5),
    HOST_SHINGLE(6),
    MAIL_TEXT_SHINGLE(7),
    SUBJ_SHINGLE(8),
    SUBJ8_SHINGLE(9),
    SUBJ16_SHINGLE(10),
    FCRC_SHINGLE(11),
    ICQ_SHINGLE(12),
    FROM_NAME_SHINGLE(13),
    FROM_ADDR_SHINGLE(14),
    LAST_SENDER_IP_SHINGLE(15),
    FIRST_SENDER_IP_SHINGLE(16),
    FROM_ADDR_TO_SUID_SHINGLE(17, 19),
    IP_FWD_SHINGLE(18),               // number of mailboxes, which receive more than 9 massages from this IP
    IP_BOX_SHINGLE(19),               // number of unique recipients from source IP
    TAGS_SHINGLE(20),
    MAIL_FROM_SHINGLE(21),
    URL_FILE_NAME_SHINGLE(22),
    URL_PATH_SHINGLE(23),
    MAILFROM_UID_SHINGLE(24),         // shingler from UID for mailfrom or for envelope-mfrm
    HELO_SHINGLE(25),
    MESSAGE_ID_SHINGLE(26),
    RCPT_SHINGLE(27),                 // rcpt-suid
    PHONE_SRC_SHINGLE(28),            // phone_new_format
    PDD_SHINGLE(29),                  // number of messages in the domain from certain UID (outgoing mail)

    MAILFROM_UID_UNIQ_SHINGLE(30, 31),// from suid for uniq rcpto key
    UID_RCPT_SHINGLE(31),             // rcpt from suid counter (outgoing mail)
    PDD_DOMN_UNIQ_SHINGLE(32, 33),    // pdd domain for uniq rcpto (outgoing mail)
    UID_PDD_DOMN_SHINGLE(33),         // rcpt from pdd domain counter (outgoing mail)
    GEO_UID_UNIQ_SHINGLE(34, 35),     // from geozone by suid uniq
    GEO_UID_SHINGLE(35),              // number of geozones for UID (outgoing mail)

    UID_MSGID_SHINGLE(36),            // so-out from uid-msgid, for bounces at so-in
    XMLR_SHINGLE(37),                 // for x-mailer or x-user-agent
    FROM_DOMAIN_SHINGLE(38),          // from domain for incoming
    BLIND_RCPTO_SHINGLE(39),          // blind recipient
    REPLYTO_ADDR_SHINGLE(40),         // replyto addr
    ATTACH_EXEC_SHINGLE(41),          // attached executable filename
    ATTACH_NAME_SHINGLE(42),          // attached filename

    IP_BOX_NO_UNIQ_SHINGLE(43),       // number of recipients from this IP, simply counter
    COMPL_UNIQ_SHINGLE(44),           // sign of unique complaint on shingle
    FIRST_FROM_SNDR_SHINGLE(45),      // 1st message from the sender
    FIRST_FROM_DMN_SHINGLE(46),       // 1st message from the domain
    RPOP_MAIL_GMAIL_SHINGLE(47),      // message from popper IMAP mail.ru or gmail
    SNDR_TO_INACTIVE_SHINGLE(48),     // sender to inactive addresses
    DOMN_TO_INACTIVE_SHINGLE(49),     // sender's domain to inactive addresses
    LOGINS_AT_DOMAIN_SHINGLE(50),     // unique logins in the domain
    AS_SHINGLE(51),                   // geo zone of autonomous system
    MFRM_UID_LIMIT_SHINGLE(52),       // outgoing limit reached for UID (outgoing mail)
    MFRM_SUID_SHINGLE(53),            // temporary added until suid disappears
    SOURCE_IP_MASKED_SHINGLE(54),     // /64 masked source for incoming, /32 for outgoing

    FAST_CHK_COUNT_SHINGLE(55),       // reserved for fast-user-rep failure counter

    FROM_PDD_ADMIN_SHINGLE(56),       // sent by PDD admin (outgoing mail)
    FROM_PDD_ADM_UNIQ_SHINGLE(57, 56),// paired to 56 (counter), uniq pdd admins-from domains (outgoing mail)

    FROMNAME_UID_SHINGLE(58),         // number of unique from:name for UID (https://st.yandex-team.ru/SODEV-1532)
                                         // (outgoing mail)
    FROMNAME_UID_UNIQ_SHINGLE(59, 58),// counter for 58 (https://st.yandex-team.ru/SODEV-1532) (outgoing mail)

    SAN_TEXT_SHINGLE(60),             // by pure visible unperson text
    SAN_FILTERED_TEXT_SHINGLE(61),    // by pure visible unperson text

    ATTACH_MD5_SHINGLE(62),           // shingle from md5-sum for attaches
    DKIM_SHINGLE(63),                 // shingle from md5-sum for DKIM (https://st.yandex-team.ru/SODEV-1951)
    COMMON_ZONE_SHINGLE(64),          // shingle from common_zone for new_host & SO

    X_FORM_ID_SHINGLE(65),            // x-form-id для писем с форм
    DKIM_DOMAIN_SHINGLE(66),          // DKIM domain

    X_SENDER_ACCOUNT(67),             // x-sender-account для писем с b2b рассылятора

    MAX_SHINGLE(68);                  // фиктивный тип для хранения верхней границы ID'шников

    private final int id;
    private final int idUniq;
    private final String str;
    private static final Map<Integer, ShingleType> idToType = new HashMap<>();

    ShingleType(final int id) {
        this.id = id;
        idUniq = 0;
        str = super.toString() + '(' + id + ')';
    }

    ShingleType(final int id, final int idUniq) {
        this.id = id;
        this.idUniq = idUniq;
        str = super.toString() + '(' + id + '<' + idUniq + ">)";
    }

    static {
        for (ShingleType type : ShingleType.values()) {
            idToType.put(type.id, type);
        }
    }

    @Nonnull
    public static ShingleType fromId(int id) {
        if (id <= UNKNOWN.id) {
            return UNKNOWN;
        } else if (id >= MAX_SHINGLE.id) {
            return MAX_SHINGLE;
        }
        return idToType.get(id);
    }

    public int id() {
        return id;
    }

    public int idUniq() {
        return idUniq;
    }

    @NoAllocation
    @Nonnull
    @Override
    public String toString() {
        return str;
    }
}

