package ru.yandex.client.so.shingler;

public class ShinglerClientException extends Exception {
    private static final long serialVersionUID = 0L;
    private static final String EXCEPTION_IN = "Exception in ";
    private static final String SHINGLER_CLIENT = " Shingler client: ";

    private final String shinglerName;

    public ShinglerClientException() {
        shinglerName = "UNKNOWN";
    }

    public String shinglerName() {
        return shinglerName;
    }

    public ShinglerClientException(final String shinglerName, final String message) {
        super(EXCEPTION_IN + shinglerName + SHINGLER_CLIENT + message);
        this.shinglerName = shinglerName;
    }

    public ShinglerClientException(final String shinglerName, final Throwable cause) {
        super(cause);
        this.shinglerName = shinglerName;
    }

    public ShinglerClientException(final String shinglerName, final String message, final Throwable cause) {
        super(EXCEPTION_IN + shinglerName + SHINGLER_CLIENT + message, cause);
        this.shinglerName = shinglerName;
    }
}
